package com.amity.socialcloud.sdk.video.data.watch

import androidx.room.Dao
import androidx.room.Query
import androidx.room.Transaction
import com.amity.socialcloud.sdk.entity.video.watch.WatchSessionEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class WatchSessionDao : EkoObjectDao<WatchSessionEntity>() {
    @Query("SELECT * from watch_session where syncState in (:syncStates) AND watchSeconds > 0 order by startTime DESC")
    abstract fun getAllImpl(syncStates: Array<String>): Flowable<List<WatchSessionEntity>>
    fun getAll(syncStates: Array<String>): Flowable<List<WatchSessionEntity>> {
        return getAllImpl(syncStates)
    }
    
    @Query("SELECT * from watch_session where sessionId = :sessionId")
    abstract fun getByIdImpl(sessionId: String): Flowable<WatchSessionEntity>
    fun getById(sessionId: String): Flowable<WatchSessionEntity> {
        return getByIdImpl(sessionId)
    }
    
    @Query("UPDATE watch_session set syncState = :toState where syncState = :fromState")
    abstract fun updateSyncStateImpl(fromState: String, toState: String)
    @Transaction
    open fun updateSyncState(fromState: WatchSessionSyncState, toState: WatchSessionSyncState) {
        updateSyncStateImpl(fromState.key, toState.key)
    }
    
    @Query("DELETE from watch_session")
    abstract override fun deleteAll()
}
