package com.amity.socialcloud.sdk.social.data.event

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.social.event.EventResponseEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable

@Dao
internal abstract class EventResponseDao : EkoObjectDao<EventResponseEntity>() {

    @Query("SELECT * FROM event_response WHERE rsvpId = :rsvpId LIMIT 1")
    abstract fun getEventResponseImpl(rsvpId: String): Flowable<EventResponseEntity>
    
    fun getEventResponse(rsvpId: String): Flowable<EventResponseEntity> {
        return getEventResponseImpl(rsvpId)
    }

    @Query("SELECT * FROM event_response WHERE rsvpId = :rsvpId")
    abstract fun observeEventResponseImpl(rsvpId: String): Flowable<List<EventResponseEntity>>
    
    fun observeEventResponse(rsvpId: String): Flowable<List<EventResponseEntity>> {
        return observeEventResponseImpl(rsvpId)
    }

    @Query("SELECT * FROM event_response WHERE rsvpId = :rsvpId LIMIT 1")
    abstract fun getByIdNowImpl(rsvpId: String): EventResponseEntity?

    override fun getByIdNow(id: String): EventResponseEntity? {
        return getByIdNowImpl(id)
    }

    @Query("SELECT * FROM event_response WHERE rsvpId IN (:rsvpIds)")
    abstract fun getByIdsNowImpl(rsvpIds: List<String>): List<EventResponseEntity>

    override fun getByIdsNow(ids: List<String>): List<EventResponseEntity> {
        return getByIdsNowImpl(ids)
    }

    @Query("SELECT * FROM event_response WHERE eventId = :eventId")
    abstract fun getByEventIdImpl(eventId: String): Flowable<List<EventResponseEntity>>

    fun getByEventId(eventId: String): Flowable<List<EventResponseEntity>> {
        return getByEventIdImpl(eventId)
    }

    @Query("SELECT * FROM event_response WHERE eventId = :eventId AND userId = :userId LIMIT 1")
    abstract fun getByEventAndUserImpl(eventId: String, userId: String): Flowable<EventResponseEntity>

    fun getByEventAndUser(eventId: String, userId: String): Flowable<EventResponseEntity> {
        return getByEventAndUserImpl(eventId, userId)
    }

    @Query("DELETE FROM event_response WHERE rsvpId = :rsvpId")
    abstract fun deleteByIdImpl(rsvpId: String): Int

    fun deleteById(rsvpId: String) {
        deleteByIdImpl(rsvpId)
    }

    @Query("DELETE FROM event_response WHERE eventId = :eventId")
    abstract fun deleteByEventIdImpl(eventId: String): Int

    fun deleteByEventId(eventId: String) {
        deleteByEventIdImpl(eventId)
    }

    @Query("DELETE FROM event_response")
    abstract override fun deleteAll()

    @Query("SELECT * FROM event_response " +
            "WHERE eventId = :eventId " +
            "AND (:isFilterByStatus = 0 OR status = :status) " +
            "AND updatedAt > :now " +
            "AND rsvpId NOT IN " +
            "(SELECT id FROM amity_paging_id WHERE hash = :hash AND nonce = :nonce) " +
            "ORDER BY updatedAt DESC " +
            "LIMIT 1")
    abstract fun getLatestEventResponseImpl(
        eventId: String,
        isFilterByStatus: Boolean,
        status: String?,
        hash: Int,
        nonce: Int,
        now: org.joda.time.DateTime
    ): Flowable<EventResponseEntity>

    fun getLatestEventResponse(
        eventId: String,
        status: String?,
        hash: Int,
        nonce: Int,
        now: org.joda.time.DateTime
    ): Flowable<EventResponseEntity> {
        return getLatestEventResponseImpl(
            eventId = eventId,
            isFilterByStatus = status != null,
            status = status,
            hash = hash,
            nonce = nonce,
            now = now
        )
    }

    @Query("UPDATE event_response SET rsvpId = :rsvpId WHERE rsvpId = :rsvpId")
    abstract fun notifyChanges(rsvpId: String)
}
