package com.amity.socialcloud.sdk.social.data.community.paging

import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class CommunitySemanticSearchKeyCreator(
    private val query: String,
    private val filter: AmityCommunityMembershipStatusFilter?,
    private val tags: AmityTags?,
    private val categoryIds: List<String>?,
    //private val includeDiscoverablePrivateCommunity: Boolean? = null
) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "query" to query,
            "filter" to (filter ?: "null"),
            "tags" to (tags ?: "null"),
            "categoryIds" to (categoryIds ?: "null"),
            //"includeDiscoverablePrivateCommunity" to (includeDiscoverablePrivateCommunity ?: "null")
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            query = query,
            filter = filter,
            tags = tags,
            categoryIds = categoryIds,
            //includeDiscoverablePrivateCommunity = includeDiscoverablePrivateCommunity
        )
    }

    private fun getConditionStatement(
        query: String,
        filter: AmityCommunityMembershipStatusFilter?,
        tags: AmityTags?,
        categoryIds: List<String>?,
        //includeDiscoverablePrivateCommunity: Boolean? = null
    ): String {
        val isDeletedFilterStatement = "community.isDeleted = 0"
        val membershipFilterStatement = when(filter) {
            AmityCommunityMembershipStatusFilter.ALL -> {
                ""
            }
            AmityCommunityMembershipStatusFilter.MEMBER -> {
                " and community.isJoined = 1"
            }
            AmityCommunityMembershipStatusFilter.NOT_MEMBER -> {
                " and community.isJoined = 0"
            }
            else -> ""
        }
//        val includeDiscoverablePrivateCommunity = includeDiscoverablePrivateCommunity?.let {
//            if (it) {
//                " and community.isDiscoverable = 1"
//            } else {
//                ""
//            }
//        } ?: ""

        // communityType filter - exclude event type communities
        val communityTypeFilterStatement = " and (community.communityType != 'event')"

        return isDeletedFilterStatement +
                membershipFilterStatement +
                //includeDiscoverablePrivateCommunity
                communityTypeFilterStatement
    }

}