package com.amity.socialcloud.sdk.infra.retrofit.conveter


import com.amity.socialcloud.sdk.model.core.error.AmityException
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Observable
import io.reactivex.rxjava3.core.Single
import retrofit2.Call
import retrofit2.CallAdapter
import retrofit2.Retrofit
import retrofit2.adapter.rxjava3.RxJava3CallAdapterFactory
import java.lang.reflect.Type

internal class Rx3ErrorHandlingCallAdapterFactory private constructor() : CallAdapter.Factory() {
    private val original = RxJava3CallAdapterFactory.create()

    override fun get(returnType: Type, annotations: Array<Annotation>, retrofit: Retrofit): CallAdapter<*, *>? {
        return RxCallAdapterWrapper(original.get(returnType, annotations, retrofit) ?: return null)
    }

    private class RxCallAdapterWrapper<R>(private val wrapped: CallAdapter<R, *>) : CallAdapter<R, Any> {

        override fun responseType(): Type {
            return wrapped.responseType()
        }

        override fun adapt(call: Call<R>): Any {
            return when (val result = wrapped.adapt(call)) {
                is Single<*> -> result.onErrorResumeNext { throwable -> Single.error(AmityException.fromThrowable(throwable)) }
                is Observable<*> -> result.onErrorResumeNext { throwable -> Observable.error(
                    AmityException.fromThrowable(throwable)) }
                is Completable -> result.onErrorResumeNext { throwable -> Completable.error(
                    AmityException.fromThrowable(throwable)) }
                else -> result
            }
        }
    }

    companion object {
        fun create(): CallAdapter.Factory {
            return Rx3ErrorHandlingCallAdapterFactory()
        }
    }

}