package com.amity.socialcloud.sdk.entity.video.watch

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionSyncState
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.MoreObjects
import com.google.common.base.Objects
import org.amity.types.ObjectId
import org.joda.time.DateTime

@Entity(tableName = "watch_session")
class WatchSessionEntity : EkoObject() {

    @PrimaryKey
    var sessionId: String = ObjectId.get().toHexString()
    var roomId: String? = null
    var watchSeconds: Long = 0L
    var startTime: DateTime? = null
    var endTime: DateTime? = null
    var syncState: String = WatchSessionSyncState.PENDING.key
    var syncedAt: DateTime? = null
    var retryCount: Int = 0

    override fun getId(): String {
        return sessionId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        return (other as? WatchSessionEntity)?.let { watch ->
            (Objects.equal(sessionId, watch.sessionId)
                    && Objects.equal(roomId, watch.roomId)
                    && Objects.equal(watchSeconds, watch.watchSeconds)
                    && Objects.equal(startTime, watch.startTime)
                    && Objects.equal(endTime, watch.endTime)
                    && Objects.equal(syncState, watch.syncState)
                    && Objects.equal(syncedAt, watch.syncedAt)
                    && Objects.equal(retryCount, watch.retryCount))
        } ?: kotlin.run { false }
    }

    override fun hashCode(): Int {
        return Objects.hashCode(sessionId, roomId, watchSeconds,
                startTime, endTime, syncState, syncedAt, retryCount)
    }

    override fun internalToString(toStringHelper: MoreObjects.ToStringHelper?): String {
        toStringHelper?.apply {
            add("sessionId", sessionId)
            add("roomId", roomId)
            add("watchSeconds", watchSeconds)
            add("startTime", startTime)
            add("endTime", endTime)
            add("syncState", syncState)
            add("syncedAt", syncedAt)
            add("retryCount", retryCount)
        }
        return super.internalToString(toStringHelper)
    }
}
