/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.PollAnswersConverter;
import com.ekoapp.ekosdk.internal.data.dao.PollDao;
import com.ekoapp.ekosdk.internal.entity.PollEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class PollDao_Impl
extends PollDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<PollEntity> __insertAdapterOfPollEntity;
    private final PollAnswersConverter __pollAnswersConverter = new PollAnswersConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<PollEntity> __deleteAdapterOfPollEntity;
    private final EntityDeleteOrUpdateAdapter<PollEntity> __updateAdapterOfPollEntity;

    public PollDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfPollEntity = new EntityInsertAdapter<PollEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `poll` (`pollId`,`userId`,`question`,`title`,`answers`,`answerType`,`status`,`closedAt`,`isDeleted`,`isVoted`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PollEntity entity) {
                if (entity.getPollId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPollId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                if (entity.getQuestion() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getQuestion());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTitle());
                }
                String _tmp = PollDao_Impl.this.__pollAnswersConverter.answersToJson(entity.getAnswers());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                if (entity.getAnswerType() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getAnswerType());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getStatus());
                }
                String _tmp_1 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getClosedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                int _tmp_2 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_2);
                int _tmp_3 = entity.isVoted() ? 1 : 0;
                statement.bindLong(10, (long)_tmp_3);
                String _tmp_4 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
                String _tmp_5 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_5);
                }
                String _tmp_6 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_6);
                }
            }
        };
        this.__deleteAdapterOfPollEntity = new EntityDeleteOrUpdateAdapter<PollEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `poll` WHERE `pollId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PollEntity entity) {
                if (entity.getPollId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPollId());
                }
            }
        };
        this.__updateAdapterOfPollEntity = new EntityDeleteOrUpdateAdapter<PollEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `poll` SET `pollId` = ?,`userId` = ?,`question` = ?,`title` = ?,`answers` = ?,`answerType` = ?,`status` = ?,`closedAt` = ?,`isDeleted` = ?,`isVoted` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `pollId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PollEntity entity) {
                if (entity.getPollId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPollId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                if (entity.getQuestion() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getQuestion());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTitle());
                }
                String _tmp = PollDao_Impl.this.__pollAnswersConverter.answersToJson(entity.getAnswers());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                if (entity.getAnswerType() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getAnswerType());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getStatus());
                }
                String _tmp_1 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getClosedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                int _tmp_2 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(9, (long)_tmp_2);
                int _tmp_3 = entity.isVoted() ? 1 : 0;
                statement.bindLong(10, (long)_tmp_3);
                String _tmp_4 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
                String _tmp_5 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_5);
                }
                String _tmp_6 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_6);
                }
                if (entity.getPollId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getPollId());
                }
            }
        };
    }

    @Override
    public void insertImpl(PollEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfPollEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends PollEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfPollEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(PollEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfPollEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends PollEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfPollEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(PollEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfPollEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(PollEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PollDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends PollEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PollDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(PollEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PollDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<PollEntity> getPoll(String pollId) {
        String _sql = "select * from poll where pollId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"poll"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from poll where pollId = ?");){
                PollEntity _result;
                int _argIndex = 1;
                if (pollId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, pollId);
                }
                int _columnIndexOfPollId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pollId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfQuestion = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"question");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfAnswers = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"answers");
                int _columnIndexOfAnswerType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"answerType");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfClosedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"closedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfIsVoted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isVoted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new PollEntity();
                    String _tmpPollId = _stmt.isNull(_columnIndexOfPollId) ? null : _stmt.getText(_columnIndexOfPollId);
                    _result.setPollId(_tmpPollId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpQuestion = _stmt.isNull(_columnIndexOfQuestion) ? null : _stmt.getText(_columnIndexOfQuestion);
                    _result.setQuestion(_tmpQuestion);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmp = _stmt.isNull(_columnIndexOfAnswers) ? null : _stmt.getText(_columnIndexOfAnswers);
                    List<AmityPollAnswer> _tmpAnswers = this.__pollAnswersConverter.jsonToAnswers(_tmp);
                    _result.setAnswers(_tmpAnswers);
                    String _tmpAnswerType = _stmt.isNull(_columnIndexOfAnswerType) ? null : _stmt.getText(_columnIndexOfAnswerType);
                    _result.setAnswerType(_tmpAnswerType);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfClosedAt) ? null : _stmt.getText(_columnIndexOfClosedAt);
                    DateTime _tmpClosedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setClosedAt(_tmpClosedAt);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsVoted);
                    boolean _tmpIsVoted = _tmp_3 != 0;
                    _result.setVoted(_tmpIsVoted);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                PollEntity pollEntity = _result;
                return pollEntity;
            }
        });
    }

    @Override
    public PollEntity getByIdNowImpl(String id) {
        String _sql = "select * from poll where pollId = ? limit 1";
        return (PollEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from poll where pollId = ? limit 1");){
                PollEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfPollId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pollId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfQuestion = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"question");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfAnswers = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"answers");
                int _columnIndexOfAnswerType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"answerType");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfClosedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"closedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfIsVoted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isVoted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new PollEntity();
                    String _tmpPollId = _stmt.isNull(_columnIndexOfPollId) ? null : _stmt.getText(_columnIndexOfPollId);
                    _result.setPollId(_tmpPollId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpQuestion = _stmt.isNull(_columnIndexOfQuestion) ? null : _stmt.getText(_columnIndexOfQuestion);
                    _result.setQuestion(_tmpQuestion);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmp = _stmt.isNull(_columnIndexOfAnswers) ? null : _stmt.getText(_columnIndexOfAnswers);
                    List<AmityPollAnswer> _tmpAnswers = this.__pollAnswersConverter.jsonToAnswers(_tmp);
                    _result.setAnswers(_tmpAnswers);
                    String _tmpAnswerType = _stmt.isNull(_columnIndexOfAnswerType) ? null : _stmt.getText(_columnIndexOfAnswerType);
                    _result.setAnswerType(_tmpAnswerType);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfClosedAt) ? null : _stmt.getText(_columnIndexOfClosedAt);
                    DateTime _tmpClosedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setClosedAt(_tmpClosedAt);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_2 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsVoted);
                    boolean _tmpIsVoted = _tmp_3 != 0;
                    _result.setVoted(_tmpIsVoted);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                PollEntity pollEntity = _result;
                return pollEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "delete from poll";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from poll");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public Completable deletePoll(String pollId) {
        String _sql = "update poll set isDeleted = 1 where pollId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update poll set isDeleted = 1 where pollId = ?");){
                int _argIndex = 1;
                if (pollId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, pollId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

