/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.api.http;

import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.http.RealResponseBody;
import okio.GzipSource;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\tH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/ekoapp/ekosdk/internal/api/http/AmityErrorInterceptor;", "Lokhttp3/Interceptor;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "getSessionStateEventBus", "()Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "unzip", "response", "amity-sdk_release"})
public final class AmityErrorInterceptor
implements Interceptor {
    @NotNull
    private final SessionStateEventBus sessionStateEventBus;

    public AmityErrorInterceptor(@NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        this.sessionStateEventBus = sessionStateEventBus;
    }

    @NotNull
    public final SessionStateEventBus getSessionStateEventBus() {
        return this.sessionStateEventBus;
    }

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) throws IOException {
        Response response;
        block4: {
            Response unzippedResponse;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            Response response2 = chain.proceed(chain.request().newBuilder().build());
            response = response2;
            if (response.isSuccessful()) break block4;
            Response response3 = unzippedResponse = this.unzip(response);
            if (response3 != null) {
                Response $this$intercept_u24lambda_u240 = response3;
                boolean bl = false;
                AmityException amityError = AmityException.Companion.fromResponse($this$intercept_u24lambda_u240);
                if (amityError.getCode() == AmityError.UNAUTHORIZED_ERROR.getCode() || amityError.getCode() == AmityError.USER_IS_GLOBAL_BANNED.getCode()) {
                    this.sessionStateEventBus.publish(new SessionState.Terminated(amityError));
                }
                Object[] objectArray = new Object[]{"<-- HTTP FAILED: " + amityError.getCode()};
                AmityLog.INSTANCE.e("SSM3", objectArray);
            }
        }
        return response;
    }

    private final Response unzip(Response response) throws IOException {
        Response response2;
        boolean hasZippedResponse;
        String contentEncoding = response.headers().get("Content-Encoding");
        boolean bl = hasZippedResponse = contentEncoding != null && Intrinsics.areEqual((Object)contentEncoding, (Object)"gzip");
        if (hasZippedResponse) {
            ResponseBody peekedResponse = response.peekBody(Long.MAX_VALUE);
            if (peekedResponse == null) {
                return response;
            }
            long contentLength = peekedResponse.contentLength();
            GzipSource responseBody = new GzipSource((Source)peekedResponse.source());
            Headers strippedHeaders = response.headers().newBuilder().build();
            response2 = response.newBuilder().headers(strippedHeaders).body((ResponseBody)new RealResponseBody(String.valueOf(peekedResponse.contentType()), contentLength, Okio.buffer((Source)((Source)responseBody)))).build();
        } else {
            response2 = response;
        }
        return response2;
    }
}

