/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.room;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007JI\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\f0\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u000e\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/core/data/room/RoomLocalDataStore;", "", "<init>", "()V", "hasInLocal", "", "roomId", "", "saveRooms", "Lio/reactivex/rxjava3/core/Completable;", "rooms", "", "Lcom/amity/socialcloud/sdk/entity/video/room/RoomEntity;", "getRoom", "observeRoom", "Lio/reactivex/rxjava3/core/Flowable;", "getRoomsByIds", "roomIds", "hardDelete", "getRoomsPagingSource", "Landroidx/paging/PagingSource;", "", "statuses", "types", "isDeleted", "sortBy", "(Ljava/util/List;Ljava/util/List;Ljava/lang/Boolean;Ljava/lang/String;)Landroidx/paging/PagingSource;", "getLatestRoom", "notifyChanges", "", "amity-sdk_release"})
public final class RoomLocalDataStore {
    public final boolean hasInLocal(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return UserDatabase.get().roomDao().getByIdNow(roomId) != null;
    }

    @NotNull
    public final Completable saveRooms(@NotNull List<? extends RoomEntity> rooms) {
        Intrinsics.checkNotNullParameter(rooms, (String)"rooms");
        Completable completable = Completable.fromAction(() -> RoomLocalDataStore.saveRooms$lambda$0(rooms));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @Nullable
    public final RoomEntity getRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Ref.ObjectRef entity = new Ref.ObjectRef();
        Completable.fromAction(() -> RoomLocalDataStore.getRoom$lambda$1(entity, roomId)).subscribeOn(Schedulers.io()).blockingAwait();
        return (RoomEntity)entity.element;
    }

    @NotNull
    public final Flowable<RoomEntity> observeRoom(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return UserDatabase.get().roomDao().getById(roomId);
    }

    @NotNull
    public final List<RoomEntity> getRoomsByIds(@NotNull List<String> roomIds) {
        Intrinsics.checkNotNullParameter(roomIds, (String)"roomIds");
        Ref.ObjectRef rooms = new Ref.ObjectRef();
        rooms.element = CollectionsKt.emptyList();
        Completable.fromAction(() -> RoomLocalDataStore.getRoomsByIds$lambda$2(rooms, roomIds)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)rooms.element;
    }

    @NotNull
    public final Completable hardDelete(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        return UserDatabase.get().roomDao().deleteById(roomId);
    }

    @NotNull
    public final PagingSource<Integer, RoomEntity> getRoomsPagingSource(@NotNull List<String> statuses, @Nullable List<String> types, @Nullable Boolean isDeleted, @Nullable String sortBy) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return UserDatabase.get().roomPagingDao().queryRoomList(statuses, types, isDeleted, sortBy);
    }

    @NotNull
    public final Flowable<RoomEntity> getLatestRoom(@NotNull List<String> statuses) {
        Intrinsics.checkNotNullParameter(statuses, (String)"statuses");
        return UserDatabase.get().roomDao().getLatestRoom(statuses);
    }

    public final void notifyChanges(@NotNull String roomId) {
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        UserDatabase.get().roomDao().updateRoom(roomId);
    }

    private static final void saveRooms$lambda$0(List $rooms) {
        if (!((Collection)$rooms).isEmpty()) {
            UserDatabase.get().roomDao().save($rooms);
        }
    }

    private static final void getRoom$lambda$1(Ref.ObjectRef $entity, String $roomId) {
        $entity.element = UserDatabase.get().roomDao().getByIdNow($roomId);
    }

    private static final void getRoomsByIds$lambda$2(Ref.ObjectRef $rooms, List $roomIds) {
        $rooms.element = UserDatabase.get().roomDao().getByIdsNow($roomIds);
    }
}

