package com.ekoapp.ekosdk.internal.data.dao

import androidx.room.Dao
import androidx.room.Query
import com.ekoapp.ekosdk.internal.ChannelMarkerEntity
import io.reactivex.rxjava3.core.Flowable

@Dao
abstract class ChannelMarkerDao : EkoObjectDao<ChannelMarkerEntity>() {
	@Query("SELECT * from channel_marker where channelId = :channelId LIMIT 1")
	abstract fun getById(channelId: String): Flowable<ChannelMarkerEntity>
	
	@Query("SELECT * from channel_marker where channelId = :channelId LIMIT 1")
	abstract override fun getByIdNow(channelId: String): ChannelMarkerEntity?
	
	@Query("DELETE from channel_marker")
	abstract override fun deleteAll()
	
	@Query("DELETE from channel_marker where channelId = :channelId")
	abstract fun deleteById(channelId: String)
}