package com.ekoapp.ekosdk.internal.api.mapper

import com.amity.socialcloud.sdk.entity.core.user.UserEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoUserDto

interface EkoUserMapper : EkoObjectMapper<EkoUserDto, UserEntity> {
	override fun update(objectOnDisk: UserEntity, objectToSave: UserEntity): UserEntity {
		return if (objectToSave.updatedAt.isAfter(objectOnDisk.updatedAt)
				|| objectToSave.updatedAt.isEqual(objectOnDisk.updatedAt)) {
			objectToSave
		} else objectOnDisk
	}
	
	companion object {
		val MAPPER: EkoUserMapper = object: EkoUserMapper {
			override fun map(dto: EkoUserDto): UserEntity {
				val user = UserEntity()
				user.userId = dto.userId
				user.mid = dto.mid
				user.path = dto.path
				user.displayName = dto.displayName
				user.roles = dto.roles
				user.permissions = dto.permissions
				user.avatarFileId = dto.avatarFileId
				user.avatarCustomUrl = dto.avatarCustomUrl
				user.description = dto.description
				user.flagCount = dto.flagCount
				user.metadata = dto.metadata
				if (dto.isGlobalBan != null) {
					user.isGlobalBan = dto.isGlobalBan!!
				}
				if (dto.isDeleted != null) {
					user.isDeleted = dto.isDeleted!!
				}
				user.createdAt = dto.createdAt
				user.updatedAt = dto.updatedAt
				return user
			}
		}
	}
}