package com.amity.socialcloud.sdk.social.domain.event

import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.amity.socialcloud.sdk.entity.social.event.EventEntity
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.social.data.event.EventRepository
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class EventLiveObjectUseCase : LiveObjectUseCase<EventEntity, AmityEvent>() {

    override fun createRepository(): AmityObjectRepository<EventEntity, AmityEvent> =
        EventRepository()

    override fun composeModel(model: AmityEvent): AmityEvent =
        EventComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.EVENT
}
