package com.amity.socialcloud.sdk.model.video.room

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

sealed class AmityRoomBroadcastData : Parcelable {

    @Parcelize
    data class DirectStreaming internal constructor(
        private val directStreamUrl: String
    ) : AmityRoomBroadcastData() {
        fun getDirectStreamUrl() = directStreamUrl
    }

    @Parcelize
    data class CoHosts internal constructor(
        private val coHostToken: String,
        private val coHostUrl: String
    ) : AmityRoomBroadcastData() {
        fun getCoHostToken() = coHostToken
        fun getCoHostUrl() = coHostUrl
    }
}

