package com.amity.socialcloud.sdk.model.social.event

enum class AmityEventOriginType(val apiKey: String) {
    COMMUNITY("community"),
    USER("user"),
    UNKNOWN("unknown");

    companion object {
        fun enumOf(value: String?): AmityEventOriginType {
            return values().find { it.apiKey == value } ?: UNKNOWN
        }
    }
}
