package com.amity.socialcloud.sdk.model.core.file

import kotlinx.parcelize.Parcelize

@Parcelize
class AmityAudio internal constructor(private val file: AmityRawFile) : AmityFileInfo(file), AmityAttachment {

    companion object {
        fun from(
            rawFile: AmityRawFile
        ): AmityAudio? {
            return if (rawFile.getFileType() != AmityFileType.AUDIO) null else AmityAudio(rawFile)
        }
    }

    fun getDuration(): Long {
        return file.getMetaData()?.get("duration")?.asLong ?: 0L
    }

}