package com.amity.socialcloud.sdk.core.data.session

import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceDto
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceRequest
import com.ekoapp.ekosdk.internal.api.http.request.RegisterVisitorRequest
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.Header
import retrofit2.http.POST

interface SessionApi {


    @POST("api/v3/sessions")
    fun registerDeviceLegacy(
        @Header("X-API-Key") apiKey: String,
        @Body request: RegisterDeviceRequest
    ): Single<RegisterDeviceDto>


    @POST("api/v5/sessions")
    fun registerDevice(
        @Header("X-API-Key") apiKey: String,
        @Body request: RegisterDeviceRequest
    ): Single<RegisterDeviceDto>

    @POST("api/v5/sessions/visitor")
    fun registerVisitor(
        @Header("X-API-Key") apiKey: String,
        @Body request: RegisterVisitorRequest
    ): Single<RegisterDeviceDto>

    @GET("api/v3/sessions")
    fun verifyAccessToken(
        @Header("X-API-Key") apiKey: String,
    ): Completable

}
