/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.entity.social.event.EventResponseEntity;
import com.amity.socialcloud.sdk.model.social.event.AmityEventResponseStatus;
import com.amity.socialcloud.sdk.social.data.event.EventResponseDao;
import com.amity.socialcloud.sdk.social.data.event.EventResponseLocalDataStore;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bJ$\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\f0\u00132\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J.\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0014J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u001e"}, d2={"Lcom/amity/socialcloud/sdk/social/data/event/EventResponseLocalDataStore;", "", "<init>", "()V", "hasInLocal", "", "rsvpId", "", "saveEventResponses", "Lio/reactivex/rxjava3/core/Completable;", "responses", "", "Lcom/amity/socialcloud/sdk/entity/social/event/EventResponseEntity;", "observe", "Lio/reactivex/rxjava3/core/Flowable;", "getEventResponse", "getEventResponses", "rsvpIds", "getEventResponsePagingSource", "Landroidx/paging/PagingSource;", "", "eventId", "status", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventResponseStatus;", "getLatestEventResponse", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "notifyChanges", "", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nEventResponseLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventResponseLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/event/EventResponseLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1193#2,2:100\n1267#2,4:102\n1056#2:106\n*S KotlinDebug\n*F\n+ 1 EventResponseLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/event/EventResponseLocalDataStore\n*L\n60#1:100,2\n60#1:102,4\n61#1:106\n*E\n"})
public final class EventResponseLocalDataStore {
    public final boolean hasInLocal(@NotNull String rsvpId) {
        Intrinsics.checkNotNullParameter((Object)rsvpId, (String)"rsvpId");
        return UserDatabase.get().eventResponseDao().getByIdNow(rsvpId) != null;
    }

    @NotNull
    public final Completable saveEventResponses(@NotNull List<? extends EventResponseEntity> responses) {
        Intrinsics.checkNotNullParameter(responses, (String)"responses");
        Completable completable = Completable.fromAction(() -> EventResponseLocalDataStore.saveEventResponses$lambda$0(responses));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Flowable<EventResponseEntity> observe(@NotNull String rsvpId) {
        Intrinsics.checkNotNullParameter((Object)rsvpId, (String)"rsvpId");
        Flowable flowable = UserDatabase.get().eventResponseDao().observeEventResponse(rsvpId).map((Function)observe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @Nullable
    public final EventResponseEntity getEventResponse(@NotNull String rsvpId) {
        Intrinsics.checkNotNullParameter((Object)rsvpId, (String)"rsvpId");
        Ref.ObjectRef response = new Ref.ObjectRef();
        Completable.fromCallable(() -> EventResponseLocalDataStore.getEventResponse$lambda$1(rsvpId, response)).subscribeOn(Schedulers.io()).blockingAwait();
        return (EventResponseEntity)response.element;
    }

    @NotNull
    public final List<EventResponseEntity> getEventResponses(@NotNull List<String> rsvpIds) {
        Intrinsics.checkNotNullParameter(rsvpIds, (String)"rsvpIds");
        Ref.ObjectRef responses = new Ref.ObjectRef();
        responses.element = CollectionsKt.emptyList();
        Completable.fromCallable(() -> EventResponseLocalDataStore.getEventResponses$lambda$5(rsvpIds, responses)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)responses.element;
    }

    @NotNull
    public final PagingSource<Integer, EventResponseEntity> getEventResponsePagingSource(@NotNull String eventId, @Nullable AmityEventResponseStatus status) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        return UserDatabase.get().eventResponsePagingDao().getEventResponsePagingSource(eventId, status);
    }

    @NotNull
    public final Flowable<EventResponseEntity> getLatestEventResponse(@NotNull String eventId, @Nullable AmityEventResponseStatus status, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        EventResponseDao eventResponseDao = UserDatabase.get().eventResponseDao();
        AmityEventResponseStatus amityEventResponseStatus = status;
        String string = amityEventResponseStatus != null ? amityEventResponseStatus.getApiKey() : null;
        int n = ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode();
        DateTime dateTime = DateTime.now();
        Intrinsics.checkNotNullExpressionValue((Object)dateTime, (String)"now(...)");
        return eventResponseDao.getLatestEventResponse(eventId, string, n, nonce, dateTime);
    }

    public final void notifyChanges(@NotNull String rsvpId) {
        Intrinsics.checkNotNullParameter((Object)rsvpId, (String)"rsvpId");
        UserDatabase.get().eventResponseDao().notifyChanges(rsvpId);
    }

    private static final void saveEventResponses$lambda$0(List $responses) {
        UserDatabase.get().eventResponseDao().save($responses);
    }

    private static final Unit getEventResponse$lambda$1(String $rsvpId, Ref.ObjectRef $response) {
        EventResponseEntity entity = UserDatabase.get().eventResponseDao().getByIdNow($rsvpId);
        if (entity != null) {
            $response.element = entity;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getEventResponses$lambda$5(List $rsvpIds, Ref.ObjectRef $responses) {
        EventResponseDao eventResponseDao = UserDatabase.get().eventResponseDao();
        List<EventResponseEntity> entities = eventResponseDao.getByIdsNow($rsvpIds);
        if (!((Collection)entities).isEmpty()) {
            void results;
            void $this$associateTo$iv$iv;
            List<EventResponseEntity> list = entities;
            Ref.ObjectRef objectRef = $responses;
            boolean bl = false;
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)$rsvpIds);
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                IndexedValue it = (IndexedValue)element$iv$iv;
                boolean bl2 = false;
                Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                map.put(pair.getFirst(), pair.getSecond());
            }
            Map orderById = destination$iv$iv;
            Iterable $this$sortedBy$iv = (Iterable)results;
            boolean $i$f$sortedBy = false;
            List sortedResponses = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderById){
                final /* synthetic */ Map $orderById$inlined;
                {
                    this.$orderById$inlined = map;
                }

                public final int compare(T a, T b) {
                    EventResponseEntity it = (EventResponseEntity)a;
                    boolean bl = false;
                    Comparable comparable = (Integer)this.$orderById$inlined.get(it.getRsvpId());
                    it = (EventResponseEntity)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderById$inlined.get(it.getRsvpId())));
                }
            });
            objectRef.element = sortedResponses;
        }
        return Unit.INSTANCE;
    }
}

