    package com.ekoapp.ekosdk.internal.util

import com.amity.socialcloud.sdk.model.core.link.AmityLink
import com.ekoapp.ekosdk.internal.api.dto.EkoLinkDto
import com.google.gson.JsonArray
import com.google.gson.JsonObject

object LinkUtils {

    /**
     * Converts a list of EkoLinkDto objects to JsonArray for entity storage
     * This is used by EntityMappers to convert DTO objects to JSON for database storage
     */
    fun convertDtosToJsonArray(linkDtos: List<EkoLinkDto>): JsonArray {
        val linkArray = JsonArray()
        linkDtos.forEach { linkDto ->
            val linkObject = JsonObject().apply {
                linkDto.index?.let { addProperty("index", it) }
                linkDto.length?.let { addProperty("length", it) }
                addProperty("url", linkDto.url)
                addProperty("renderPreview", linkDto.renderPreview)
                linkDto.domain?.let { addProperty("domain", it) }
                linkDto.title?.let { addProperty("title", it) }
                linkDto.imageUrl?.let { addProperty("imageUrl", it) }
            }
            linkArray.add(linkObject)
        }
        return linkArray
    }

    /**
     * Parses link data from JsonArray to a list of AmityLink objects
     * This is used by ModelMappers to convert stored JSON to model objects
     */
    fun parseLinkData(linksArray: JsonArray?): List<AmityLink> {
        if (linksArray == null || linksArray.size() == 0) {
            return emptyList()
        }

        return linksArray.mapNotNull { element ->
            try {
                val obj = element.asJsonObject
                AmityLink(
                    index = if (obj.has("index") && !obj.get("index").isJsonNull) obj.get("index").asInt else null,
                    length = if (obj.has("length") && !obj.get("length").isJsonNull) obj.get("length").asInt else null,
                    url = obj.get("url").asString,
                    renderPreview = obj.get("renderPreview").asBoolean,
                    domain = if (obj.has("domain") && !obj.get("domain").isJsonNull) obj.get("domain").asString else null,
                    title = if (obj.has("title") && !obj.get("title").isJsonNull) obj.get("title").asString else null,
                    imageUrl = if (obj.has("imageUrl") && !obj.get("imageUrl").isJsonNull) obj.get("imageUrl").asString else null
                )
            } catch (e: Exception) {
                null
            }
        }
    }
}
