package com.amity.socialcloud.sdk.video.domain.room

import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class CreateRoomUseCase {
    fun execute(
        title: String,
        description: String?,
        thumbnailFileId: String?,
        metadata: JsonObject?,
        liveChatEnabled: Boolean?,
        parentRoomId: String?,
        participants: List<String>,
    ): Single<AmityRoom> {
        return RoomRepository().createRoom(
            title = title,
            description = description,
            thumbnailFileId = thumbnailFileId,
            metadata = metadata,
            liveChatEnabled = liveChatEnabled,
            parentRoomId = parentRoomId,
            participants = participants
        ).flatMap { id -> GetRoomUseCase().execute(id).firstOrError() }
    }
}

