package com.amity.socialcloud.sdk.core.session.model

import com.amity.socialcloud.sdk.model.core.invitation.AmityInvitation
import com.amity.socialcloud.sdk.model.video.room.AmityRoom

sealed class AmityCoHostEvent(val roomId: String) {

    class CoHostInvited(val invitationId: String, val invitation: AmityInvitation) : AmityCoHostEvent(roomId = invitation.getTargetId())

    class CoHostInviteAccepted(val invitationId: String, val invitation: AmityInvitation) : AmityCoHostEvent(roomId = invitation.getTargetId())

    class CoHostInviteCancelled(val invitationId: String, val invitation: AmityInvitation) : AmityCoHostEvent(roomId = invitation.getTargetId())

    class CoHostInviteRejected(val invitationId: String, val invitation: AmityInvitation) : AmityCoHostEvent(roomId = invitation.getTargetId())

    class CoHostJoined(val room: AmityRoom, val actorInternalId: String?) : AmityCoHostEvent(room.getRoomId())

    class CoHostLeft(val room: AmityRoom, val actorInternalId: String?) : AmityCoHostEvent(room.getRoomId())

    class CoHostRemoved(val room: AmityRoom, val actorInternalId: String?) : AmityCoHostEvent(room.getRoomId())

}