package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.common.QueryPersister
import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.amity.socialcloud.sdk.dto.video.RoomListDto
import com.amity.socialcloud.sdk.social.data.post.PostLocalDataStore
import io.reactivex.Single
import io.reactivex.rxjava3.core.Completable

internal class RoomQueryPersister : QueryPersister<RoomListDto>() {
    override fun persist(dto: RoomListDto): Completable {
        return FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files ?: emptyList()))
            .andThen(UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users ?: emptyList())))
            .andThen(UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users ?: emptyList())))
            .andThen(RoomModerationLocalDataStore().saveModerations(RoomModerationEntityMapper().map(dto.roomModerations ?: emptyList())))
            .andThen(RoomLocalDataStore().saveRooms(RoomEntityMapper().map(dto.roomChildren ?: emptyList())))
            .andThen(RoomLocalDataStore().saveRooms(RoomEntityMapper().map(dto.rooms ?: emptyList())))
            .andThen(Completable.defer { Completable.fromAction {
                val roomPosts = dto.rooms?.filter {
                    it.referenceType != null && it.referenceType == "post"
                }?.mapNotNull {
                    it.referenceId
                } ?: emptyList()
                roomPosts.forEach {
                    PostLocalDataStore().notifyPost(it)
                }
            } })
    }
}

