package com.amity.socialcloud.sdk.api.social.member.query

enum class AmityCommunityMembershipSortOption(val apiKey: String) {

    DISPLAY_NAME("displayName"),
    LAST_JOIN("lastJoin"),
    FIRST_CREATED("firstCreated"),
    LAST_CREATED("lastCreated");

    companion object {
        fun enumOf(apiKey: String?): AmityCommunityMembershipSortOption {
            return values().find { apiKey == it.apiKey } ?: DISPLAY_NAME
        }
    }

}