/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.category;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.category.query.AmityCommunityCategorySortOption;
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0010\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J)\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0002\u0010\u0017J+\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/amity/socialcloud/sdk/social/data/category/CategoryLocalDataStore;", "", "<init>", "()V", "saveCategories", "Lio/reactivex/rxjava3/core/Completable;", "categories", "", "Lcom/amity/socialcloud/sdk/entity/social/category/CommunityCategoryEntity;", "getCategory", "categoryId", "", "observeCategory", "Lio/reactivex/rxjava3/core/Flowable;", "getCategories", "categoryIds", "getCategoryPagingSource", "Landroidx/paging/PagingSource;", "", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/category/query/AmityCommunityCategorySortOption;", "isDeleted", "", "(Lcom/amity/socialcloud/sdk/api/social/category/query/AmityCommunityCategorySortOption;Ljava/lang/Boolean;)Landroidx/paging/PagingSource;", "getLatestCategory", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "amity-sdk_release"})
public final class CategoryLocalDataStore {
    @NotNull
    public final Completable saveCategories(@NotNull List<? extends CommunityCategoryEntity> categories) {
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        Completable completable = Completable.fromAction(() -> CategoryLocalDataStore.saveCategories$lambda$0(categories));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @Nullable
    public final CommunityCategoryEntity getCategory(@NotNull String categoryId) {
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        return UserDatabase.get().categoryDao().getByIdNow(categoryId);
    }

    @NotNull
    public final Flowable<CommunityCategoryEntity> observeCategory(@NotNull String categoryId) {
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Flowable<CommunityCategoryEntity> flowable = UserDatabase.get().categoryDao().observeById(categoryId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"observeById(...)");
        return flowable;
    }

    @NotNull
    public final List<CommunityCategoryEntity> getCategories(@NotNull List<String> categoryIds) {
        Intrinsics.checkNotNullParameter(categoryIds, (String)"categoryIds");
        Ref.ObjectRef categories = new Ref.ObjectRef();
        categories.element = CollectionsKt.emptyList();
        Completable.fromCallable(() -> CategoryLocalDataStore.getCategories$lambda$1(categoryIds, categories)).subscribeOn(Schedulers.io()).blockingAwait();
        return (List)categories.element;
    }

    @NotNull
    public final PagingSource<Integer, CommunityCategoryEntity> getCategoryPagingSource(@NotNull AmityCommunityCategorySortOption sortOption, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return UserDatabase.get().categoryPagingDao().getCategoryPagingSource(sortOption, isDeleted);
    }

    @NotNull
    public final Flowable<CommunityCategoryEntity> getLatestCategory(@Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable<CommunityCategoryEntity> flowable = UserDatabase.get().categoryDao().getLatestCategory(isDeleted, ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode(), nonce, DateTime.now());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getLatestCategory(...)");
        return flowable;
    }

    private static final void saveCategories$lambda$0(List $categories) {
        UserDatabase.get().categoryDao().save($categories);
    }

    private static final Unit getCategories$lambda$1(List $categoryIds, Ref.ObjectRef $categories) {
        EkoCommunityCategoryDao categoryDao = UserDatabase.get().categoryDao();
        List<CommunityCategoryEntity> list = categoryDao.getByIdsNow($categoryIds);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getByIdsNow(...)");
        List<CommunityCategoryEntity> entities = list;
        if (!((Collection)entities).isEmpty()) {
            $categories.element = entities;
        }
        return Unit.INSTANCE;
    }
}

