/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.storytarget;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.story.StoryTargetEntity;
import com.amity.socialcloud.sdk.social.data.storytarget.StoryTargetDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class StoryTargetDao_Impl
extends StoryTargetDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<StoryTargetEntity> __insertAdapterOfStoryTargetEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<StoryTargetEntity> __deleteAdapterOfStoryTargetEntity;
    private final EntityDeleteOrUpdateAdapter<StoryTargetEntity> __updateAdapterOfStoryTargetEntity;

    public StoryTargetDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfStoryTargetEntity = new EntityInsertAdapter<StoryTargetEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `storyTarget` (`uniqueId`,`targetId`,`targetType`,`lastStoryExpiresAt`,`lastStorySeenExpiresAt`,`targetUpdatedAt`,`hasUnseen`,`localSortingDate`,`localLastStoryExpiresAt`,`localLastStorySeenExpiresAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StoryTargetEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetType());
                }
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastStoryExpiresAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastStorySeenExpiresAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getTargetUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                int _tmp_3 = entity.getHasUnseen() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_3);
                String _tmp_4 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLocalSortingDate());
                if (_tmp_4 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_4);
                }
                String _tmp_5 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLocalLastStoryExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_5);
                }
                String _tmp_6 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLocalLastStorySeenExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_6);
                }
                String _tmp_7 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_7);
                }
                String _tmp_8 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_8);
                }
                String _tmp_9 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_9 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_9);
                }
            }
        };
        this.__deleteAdapterOfStoryTargetEntity = new EntityDeleteOrUpdateAdapter<StoryTargetEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `storyTarget` WHERE `uniqueId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StoryTargetEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
            }
        };
        this.__updateAdapterOfStoryTargetEntity = new EntityDeleteOrUpdateAdapter<StoryTargetEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `storyTarget` SET `uniqueId` = ?,`targetId` = ?,`targetType` = ?,`lastStoryExpiresAt` = ?,`lastStorySeenExpiresAt` = ?,`targetUpdatedAt` = ?,`hasUnseen` = ?,`localSortingDate` = ?,`localLastStoryExpiresAt` = ?,`localLastStorySeenExpiresAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `uniqueId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StoryTargetEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetType());
                }
                String _tmp = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastStoryExpiresAt());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                String _tmp_1 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastStorySeenExpiresAt());
                if (_tmp_1 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_1);
                }
                String _tmp_2 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getTargetUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                int _tmp_3 = entity.getHasUnseen() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_3);
                String _tmp_4 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLocalSortingDate());
                if (_tmp_4 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_4);
                }
                String _tmp_5 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLocalLastStoryExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_5);
                }
                String _tmp_6 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLocalLastStorySeenExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_6);
                }
                String _tmp_7 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_7);
                }
                String _tmp_8 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_8);
                }
                String _tmp_9 = StoryTargetDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_9 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_9);
                }
                if (entity.getUniqueId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getUniqueId());
                }
            }
        };
    }

    @Override
    public void insertImpl(StoryTargetEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfStoryTargetEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends StoryTargetEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfStoryTargetEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(StoryTargetEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfStoryTargetEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends StoryTargetEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfStoryTargetEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(StoryTargetEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfStoryTargetEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(StoryTargetEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StoryTargetDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends StoryTargetEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StoryTargetDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(StoryTargetEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StoryTargetDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<StoryTargetEntity> observeStory(String uniqueId) {
        String _sql = "select * from storyTarget where uniqueId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"storyTarget"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from storyTarget where uniqueId = ?");){
                StoryTargetEntity _result;
                int _argIndex = 1;
                if (uniqueId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, uniqueId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStoryExpiresAt");
                int _columnIndexOfLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStorySeenExpiresAt");
                int _columnIndexOfTargetUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUpdatedAt");
                int _columnIndexOfHasUnseen = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasUnseen");
                int _columnIndexOfLocalSortingDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localSortingDate");
                int _columnIndexOfLocalLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStoryExpiresAt");
                int _columnIndexOfLocalLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStorySeenExpiresAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryTargetEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmp = _stmt.isNull(_columnIndexOfLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStoryExpiresAt);
                    DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStorySeenExpiresAt);
                    DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTargetUpdatedAt) ? null : _stmt.getText(_columnIndexOfTargetUpdatedAt);
                    DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfHasUnseen);
                    boolean _tmpHasUnseen = _tmp_3 != 0;
                    _result.setHasUnseen(_tmpHasUnseen);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLocalSortingDate) ? null : _stmt.getText(_columnIndexOfLocalSortingDate);
                    DateTime _tmpLocalSortingDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLocalSortingDate(_tmpLocalSortingDate);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLocalLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStoryExpiresAt);
                    DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLocalLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStorySeenExpiresAt);
                    DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryTargetEntity storyTargetEntity = _result;
                return storyTargetEntity;
            }
        });
    }

    @Override
    public StoryTargetEntity getByIdNowImpl(String uniqueId) {
        String _sql = "select * from storyTarget where uniqueId = ?";
        return (StoryTargetEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from storyTarget where uniqueId = ?");){
                StoryTargetEntity _result;
                int _argIndex = 1;
                if (uniqueId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, uniqueId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStoryExpiresAt");
                int _columnIndexOfLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStorySeenExpiresAt");
                int _columnIndexOfTargetUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUpdatedAt");
                int _columnIndexOfHasUnseen = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasUnseen");
                int _columnIndexOfLocalSortingDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localSortingDate");
                int _columnIndexOfLocalLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStoryExpiresAt");
                int _columnIndexOfLocalLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStorySeenExpiresAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryTargetEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmp = _stmt.isNull(_columnIndexOfLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStoryExpiresAt);
                    DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStorySeenExpiresAt);
                    DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTargetUpdatedAt) ? null : _stmt.getText(_columnIndexOfTargetUpdatedAt);
                    DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfHasUnseen);
                    boolean _tmpHasUnseen = _tmp_3 != 0;
                    _result.setHasUnseen(_tmpHasUnseen);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLocalSortingDate) ? null : _stmt.getText(_columnIndexOfLocalSortingDate);
                    DateTime _tmpLocalSortingDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLocalSortingDate(_tmpLocalSortingDate);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLocalLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStoryExpiresAt);
                    DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLocalLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStorySeenExpiresAt);
                    DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryTargetEntity storyTargetEntity = _result;
                return storyTargetEntity;
            }
        });
    }

    @Override
    public StoryTargetEntity getStoryTarget(String targetType, String targetId) {
        String _sql = "select * from storyTarget where targetType = ? and targetId = ?";
        return (StoryTargetEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from storyTarget where targetType = ? and targetId = ?");){
                StoryTargetEntity _result;
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStoryExpiresAt");
                int _columnIndexOfLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStorySeenExpiresAt");
                int _columnIndexOfTargetUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUpdatedAt");
                int _columnIndexOfHasUnseen = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasUnseen");
                int _columnIndexOfLocalSortingDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localSortingDate");
                int _columnIndexOfLocalLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStoryExpiresAt");
                int _columnIndexOfLocalLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStorySeenExpiresAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryTargetEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmp = _stmt.isNull(_columnIndexOfLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStoryExpiresAt);
                    DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStorySeenExpiresAt);
                    DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTargetUpdatedAt) ? null : _stmt.getText(_columnIndexOfTargetUpdatedAt);
                    DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfHasUnseen);
                    boolean _tmpHasUnseen = _tmp_3 != 0;
                    _result.setHasUnseen(_tmpHasUnseen);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLocalSortingDate) ? null : _stmt.getText(_columnIndexOfLocalSortingDate);
                    DateTime _tmpLocalSortingDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLocalSortingDate(_tmpLocalSortingDate);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLocalLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStoryExpiresAt);
                    DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLocalLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStorySeenExpiresAt);
                    DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryTargetEntity storyTargetEntity = _result;
                return storyTargetEntity;
            }
        });
    }

    @Override
    public Flowable<StoryTargetEntity> getLatestStoryTargetsImpl(Boolean hasUnseen, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.updatedAt > ? and storyTarget.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by storyTarget.updatedAt desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"storyTarget", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.updatedAt > ? and storyTarget.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by storyTarget.updatedAt desc limit 1");){
                StoryTargetEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                Integer n = hasUnseen == null ? null : (_tmp = Integer.valueOf(hasUnseen != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 2;
                Integer n2 = hasUnseen == null ? null : (_tmp_1 = Integer.valueOf(hasUnseen != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 3;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 4;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStoryExpiresAt");
                int _columnIndexOfLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastStorySeenExpiresAt");
                int _columnIndexOfTargetUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetUpdatedAt");
                int _columnIndexOfHasUnseen = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"hasUnseen");
                int _columnIndexOfLocalSortingDate = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localSortingDate");
                int _columnIndexOfLocalLastStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStoryExpiresAt");
                int _columnIndexOfLocalLastStorySeenExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"localLastStorySeenExpiresAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryTargetEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStoryExpiresAt);
                    DateTime _tmpLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setLastStoryExpiresAt(_tmpLastStoryExpiresAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLastStorySeenExpiresAt);
                    DateTime _tmpLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLastStorySeenExpiresAt(_tmpLastStorySeenExpiresAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfTargetUpdatedAt) ? null : _stmt.getText(_columnIndexOfTargetUpdatedAt);
                    DateTime _tmpTargetUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setTargetUpdatedAt(_tmpTargetUpdatedAt);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfHasUnseen);
                    boolean _tmpHasUnseen = _tmp_6 != 0;
                    _result.setHasUnseen(_tmpHasUnseen);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfLocalSortingDate) ? null : _stmt.getText(_columnIndexOfLocalSortingDate);
                    DateTime _tmpLocalSortingDate = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setLocalSortingDate(_tmpLocalSortingDate);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfLocalLastStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStoryExpiresAt);
                    DateTime _tmpLocalLastStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setLocalLastStoryExpiresAt(_tmpLocalLastStoryExpiresAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfLocalLastStorySeenExpiresAt) ? null : _stmt.getText(_columnIndexOfLocalLastStorySeenExpiresAt);
                    DateTime _tmpLocalLastStorySeenExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setLocalLastStorySeenExpiresAt(_tmpLocalLastStorySeenExpiresAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryTargetEntity storyTargetEntity = _result;
                return storyTargetEntity;
            }
        });
    }

    @Override
    public List<String> findCacheKeysImpl(Boolean hasUnseen, DateTime expiresAfter) {
        String _sql = "select storyTarget.uniqueId from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.localSortingDate > ? and storyTarget.localSortingDate = storyTarget.localLastStoryExpiresAt";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select storyTarget.uniqueId from storyTarget where storyTarget.hasUnseen = (case when ? is null then hasUnseen else ? end) and storyTarget.localSortingDate > ? and storyTarget.localSortingDate = storyTarget.localLastStoryExpiresAt");){
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                Integer n = hasUnseen == null ? null : (_tmp = Integer.valueOf(hasUnseen != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 2;
                Integer n2 = hasUnseen == null ? null : (_tmp_1 = Integer.valueOf(hasUnseen != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 3;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(expiresAfter);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                ArrayList<String> _result = new ArrayList<String>();
                while (_stmt.step()) {
                    String _item = _stmt.isNull(0) ? null : _stmt.getText(0);
                    _result.add(_item);
                }
                ArrayList<String> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "delete from storyTarget";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from storyTarget");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public Completable updateStoryTargetLocalLastStoryExpiresAt(String targetType, String targetId, DateTime localLastStoryExpiresAt) {
        String _sql = "update storyTarget set localLastStoryExpiresAt = ? where targetType = ? and targetId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update storyTarget set localLastStoryExpiresAt = ? where targetType = ? and targetId = ?");){
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(localLastStoryExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public Completable updateStoryTargetLastStoryExpiresAt(String targetType, String targetId, DateTime lastStoryExpiresAt) {
        String _sql = "update storyTarget set lastStoryExpiresAt = ? where targetType = ? and targetId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update storyTarget set lastStoryExpiresAt = ? where targetType = ? and targetId = ?");){
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(lastStoryExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public Completable updateStoryTargetLocalLastStorySeenExpiresAt(String targetType, String targetId, DateTime localLastStorySeenExpiresAt) {
        String _sql = "update storyTarget set localLastStorySeenExpiresAt = ? where targetType = ? and targetId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update storyTarget set localLastStorySeenExpiresAt = ? where targetType = ? and targetId = ?");){
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(localLastStorySeenExpiresAt);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 3;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public Completable updateStoryTargetHasUnseen(String targetType, String targetId, boolean hasUnseen, DateTime localSortingDate) {
        String _sql = "update storyTarget set localSortingDate = ?, hasUnseen = ? where targetType = ? and targetId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update storyTarget set localSortingDate = ?, hasUnseen = ? where targetType = ? and targetId = ?");){
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(localSortingDate);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                int _tmp_1 = hasUnseen ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_1);
                _argIndex = 3;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 4;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

