/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.ad;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.core.data.ad.AdsSettingsDao;
import com.amity.socialcloud.sdk.entity.core.ad.AdsSettingsEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class AdsSettingsDao_Impl
extends AdsSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<AdsSettingsEntity> __insertAdapterOfAdsSettingsEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<AdsSettingsEntity> __deleteAdapterOfAdsSettingsEntity;
    private final EntityDeleteOrUpdateAdapter<AdsSettingsEntity> __updateAdapterOfAdsSettingsEntity;

    public AdsSettingsDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfAdsSettingsEntity = new EntityInsertAdapter<AdsSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `ads_settings` (`settingId`,`enabled`,`maxActiveAds`,`frequency`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AdsSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
                int _tmp = entity.getEnabled() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                statement.bindLong(3, (long)entity.getMaxActiveAds());
                String _tmp_1 = AdsSettingsDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getFrequency());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_1);
                }
                String _tmp_2 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfAdsSettingsEntity = new EntityDeleteOrUpdateAdapter<AdsSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `ads_settings` WHERE `settingId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AdsSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
            }
        };
        this.__updateAdapterOfAdsSettingsEntity = new EntityDeleteOrUpdateAdapter<AdsSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `ads_settings` SET `settingId` = ?,`enabled` = ?,`maxActiveAds` = ?,`frequency` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `settingId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull AdsSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
                int _tmp = entity.getEnabled() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                statement.bindLong(3, (long)entity.getMaxActiveAds());
                String _tmp_1 = AdsSettingsDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getFrequency());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_1);
                }
                String _tmp_2 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = AdsSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
                if (entity.getSettingId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getSettingId());
                }
            }
        };
    }

    @Override
    public void insertImpl(AdsSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAdsSettingsEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends AdsSettingsEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfAdsSettingsEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(AdsSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfAdsSettingsEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends AdsSettingsEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfAdsSettingsEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(AdsSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfAdsSettingsEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(AdsSettingsEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AdsSettingsDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends AdsSettingsEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AdsSettingsDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(AdsSettingsEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            AdsSettingsDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Single<List<AdsSettingsEntity>> getByIdImpl(String id) {
        String _sql = "SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1";
        return RxRoom.createSingle((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1");){
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfSettingId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"settingId");
                int _columnIndexOfEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"enabled");
                int _columnIndexOfMaxActiveAds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"maxActiveAds");
                int _columnIndexOfFrequency = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"frequency");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<AdsSettingsEntity> _result = new ArrayList<AdsSettingsEntity>();
                while (_stmt.step()) {
                    String _tmpSettingId = _stmt.isNull(_columnIndexOfSettingId) ? null : _stmt.getText(_columnIndexOfSettingId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfEnabled);
                    boolean _tmpEnabled = _tmp != 0;
                    int _tmpMaxActiveAds = (int)_stmt.getLong(_columnIndexOfMaxActiveAds);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfFrequency) ? null : _stmt.getText(_columnIndexOfFrequency);
                    JsonObject _tmpFrequency = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    AdsSettingsEntity _item = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<AdsSettingsEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public AdsSettingsEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1";
        return (AdsSettingsEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from ads_settings where ads_settings.settingId = ? LIMIT 1");){
                AdsSettingsEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfSettingId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"settingId");
                int _columnIndexOfEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"enabled");
                int _columnIndexOfMaxActiveAds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"maxActiveAds");
                int _columnIndexOfFrequency = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"frequency");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpSettingId = _stmt.isNull(_columnIndexOfSettingId) ? null : _stmt.getText(_columnIndexOfSettingId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfEnabled);
                    boolean _tmpEnabled = _tmp != 0;
                    int _tmpMaxActiveAds = (int)_stmt.getLong(_columnIndexOfMaxActiveAds);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfFrequency) ? null : _stmt.getText(_columnIndexOfFrequency);
                    JsonObject _tmpFrequency = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                AdsSettingsEntity adsSettingsEntity = _result;
                return adsSettingsEntity;
            }
        });
    }

    @Override
    public AdsSettingsEntity getNowImpl() {
        String _sql = "SELECT * from ads_settings LIMIT 1";
        return (AdsSettingsEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from ads_settings LIMIT 1");){
                AdsSettingsEntity _result;
                int _columnIndexOfSettingId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"settingId");
                int _columnIndexOfEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"enabled");
                int _columnIndexOfMaxActiveAds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"maxActiveAds");
                int _columnIndexOfFrequency = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"frequency");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpSettingId = _stmt.isNull(_columnIndexOfSettingId) ? null : _stmt.getText(_columnIndexOfSettingId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfEnabled);
                    boolean _tmpEnabled = _tmp != 0;
                    int _tmpMaxActiveAds = (int)_stmt.getLong(_columnIndexOfMaxActiveAds);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfFrequency) ? null : _stmt.getText(_columnIndexOfFrequency);
                    JsonObject _tmpFrequency = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                AdsSettingsEntity adsSettingsEntity = _result;
                return adsSettingsEntity;
            }
        });
    }

    @Override
    public List<AdsSettingsEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from ads_settings where ads_settings.settingId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : ids) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfSettingId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"settingId");
                int _columnIndexOfEnabled = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"enabled");
                int _columnIndexOfMaxActiveAds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"maxActiveAds");
                int _columnIndexOfFrequency = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"frequency");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<AdsSettingsEntity> _result = new ArrayList<AdsSettingsEntity>();
                while (_stmt.step()) {
                    String _tmpSettingId = _stmt.isNull(_columnIndexOfSettingId) ? null : _stmt.getText(_columnIndexOfSettingId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfEnabled);
                    boolean _tmpEnabled = _tmp != 0;
                    int _tmpMaxActiveAds = (int)_stmt.getLong(_columnIndexOfMaxActiveAds);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfFrequency) ? null : _stmt.getText(_columnIndexOfFrequency);
                    JsonObject _tmpFrequency = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    AdsSettingsEntity _item_1 = new AdsSettingsEntity(_tmpSettingId, _tmpEnabled, _tmpMaxActiveAds, _tmpFrequency);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<AdsSettingsEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from ads_settings";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from ads_settings");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

