package com.ekoapp.ekosdk.internal.api.socket.request

import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName

/**
 * Request body for PUT /api/v1/rooms/{roomId}
 * All fields optional.
 * - title
 * - description
 * - thumbnailFileId
 * - metadata
 * - channelEnabled
 * - participants (applicable only for coHosts type)
 */
 data class UpdateRoomRequest(
    @SerializedName("title") val title: String? = null,
    @SerializedName("description") val description: String? = null,
    @SerializedName("thumbnailFileId") val thumbnailFileId: String? = null,
    @SerializedName("metadata") val metadata: JsonObject? = null,
    @SerializedName("liveChatEnabled") val liveChatEnabled: Boolean? = null,
    @SerializedName("participants") val participants: List<String>? = null,
 )
