package com.amity.socialcloud.sdk.video.domain.stream

import com.amity.socialcloud.sdk.model.video.stream.AmityRecordingData
import com.amity.socialcloud.sdk.model.video.stream.AmityStream
import com.amity.socialcloud.sdk.model.video.stream.AmityWatcherData
import com.amity.socialcloud.sdk.streamapi.PartialStreamData
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class GetStreamDataUseCase {

    fun execute(streamId: String): Single<PartialStreamData> {
        FetchStreamUseCase().execute(streamId).subscribe()
        return GetStreamUseCase().execute(streamId)
            .firstOrError()
            .map { stream ->
                val watchingUrls : List<String>? = when (stream.getStatus() ) {
                    AmityStream.Status.LIVE -> {
                        val url = getSerializedWatcherData(stream)?.getUrl(AmityWatcherData.Format.FLV) ?: ""
                        listOf(url)
                    }
                    AmityStream.Status.RECORDED -> {
                        getSerializedRecordings(stream).map { recording ->
                            recording?.getUrl(AmityRecordingData.Format.MP4) ?: ""
                        }.filter { url ->
                            url.isNotEmpty()
                        }
                    }
                    else -> {
                        null
                    }
                }
                PartialStreamData(
                    streamId = streamId,
                    isLive = stream.getStatus() == AmityStream.Status.LIVE,
                    resolution = stream.getResolution() ?: "SD",
                    broadcastingUrl = stream.getBroadcasterData()?.getUrl(),
                    watchingUrls = watchingUrls
                )
            }
    }

    private fun getSerializedRecordings(stream: AmityStream): List<AmityRecordingData?> {
        stream.recordings?.let {
            val recordingDataList = arrayListOf<AmityRecordingData>()
            it.forEach { jsonElement ->
                if (jsonElement is JsonObject) {
                    recordingDataList.add(AmityRecordingData(jsonElement))
                }
            }
            return recordingDataList
        } ?: kotlin.run {
            return listOf()
        }
    }

    private fun getSerializedWatcherData(stream: AmityStream): AmityWatcherData? {
        stream.watcherData?.let {
            return AmityWatcherData(it)
        } ?: kotlin.run {
            return null
        }
    }

}