package com.amity.socialcloud.sdk.model.core.notificationtray

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.core.domain.notificationtray.seen.MarkNotificationItemSeenUseCase
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Completable
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
data class AmityNotificationTrayItem internal constructor(
    private var targetId: String,
    private var targetType: String,
    private var actionType: String,
    private var actionReferenceId: String,
    private var actors: List<AmityNotificationTrayActor>? = emptyList(),
    private var actorsCount: Int,
    private var id: String,
    private var daySegment: DateTime?,
    private var lastOccurredAt: DateTime?,
    private var lastSeenAt: DateTime?,
    private var parentId: String,
    private var referenceId: String,
    private var referenceType: String,
    private var templatedText: String,
    private var text: String,
    private var trayItemCategory: String,
    private var isSeen: Boolean? = null,
    private var isRecent: Boolean? = null,
    internal var actorUsers: List<AmityUser>? = null,
    internal var event: AmityEvent? = null,
): Parcelable, ReactorObject {

    fun getTargetId(): String {
        return targetId
    }

    fun getTargetType(): String {
        return targetType
    }

    fun getActionType(): String {
        return actionType
    }

    fun getActionReferenceId(): String {
        return actionReferenceId
    }

    fun getActors(): List<AmityNotificationTrayActor>? {
        return actors
    }

    fun getActorsCount(): Int {
        return actorsCount
    }

    fun getId(): String {
        return id
    }

    fun getDaySegment(): DateTime? {
        return daySegment
    }

    fun getLastOccurredAt(): DateTime? {
        return lastOccurredAt
    }

    fun getLastSeenAt(): DateTime? {
        return lastSeenAt
    }

    fun getParentId(): String {
        return parentId
    }

    fun getReferenceId(): String {
        return referenceId
    }

    fun getReferenceType(): String {
        return referenceType
    }

    fun getTemplatedText(): String {
        return templatedText
    }

    fun getText(): String {
        return text
    }

    fun isSeen(): Boolean? {
        return isSeen
    }

    fun isRecent(): Boolean? {
        return isRecent
    }

    fun getTrayItemCategory(): String {
        return trayItemCategory
    }

    fun markSeen(): Completable {
        return MarkNotificationItemSeenUseCase().execute(id)
    }

    fun getUsers(): List<AmityUser>? {
        return actorUsers
    }

    fun getEvent(): AmityEvent? {
        return event
    }

    override fun updatedAt(): DateTime? {
        return lastOccurredAt
    }

    override fun uniqueId(): String {
        return id
    }

    companion object {
        internal fun generateUniqueId(targetType: String, targetId: String): String {
            return "$targetType/$targetId"
        }
    }
}