package com.amity.socialcloud.sdk.entity.core.ad

import androidx.room.Entity
import androidx.room.PrimaryKey
import com.amity.socialcloud.sdk.model.core.ad.AmityAdvertiser
import com.ekoapp.ekosdk.EkoObject
import com.google.common.base.Objects
import org.amity.types.ObjectId
import org.joda.time.DateTime


@Entity(tableName = "advertiser")
open class AdvertiserEntity(
    @PrimaryKey
    var advertiserId: String = ObjectId.get().toHexString(),
    var name: String = "",
    var companyName: String = "",
    var avatarFileId: String? = null,
) : EkoObject() {

    override fun getId(): String {
        return advertiserId
    }

    override fun equals(other: Any?): Boolean {
        if (other == null) return false
        if (other === this) return true
        if (other.javaClass != javaClass) return false
        return (Objects.equal(advertiserId, (other as AdvertiserEntity).advertiserId)
                && Objects.equal(name, other.name)
                && Objects.equal(companyName, other.companyName)
                && Objects.equal(avatarFileId, other.avatarFileId)
                && Objects.equal(updatedAt, other.updatedAt))
    }

    override fun hashCode(): Int {
        return Objects.hashCode(
            advertiserId,
            name,
            companyName,
            avatarFileId,
            updatedAt,
        )
    }

}

fun AdvertiserEntity.toModel(): AmityAdvertiser {
    return AmityAdvertiser(
        advertiserId = advertiserId,
        name = name,
        companyName = companyName,
        avatarFileId = avatarFileId,
        createdAt = createdAt ?: DateTime.now(),
        updatedAt = updatedAt ?: DateTime.now()
    )
}