package com.amity.socialcloud.sdk.core.data.settings.network

import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsDto
import com.amity.socialcloud.sdk.core.data.settings.network.moderation.ValidateTextsRequest
import com.amity.socialcloud.sdk.core.data.settings.network.moderation.ValidateUrlsRequest
import com.amity.socialcloud.sdk.dto.core.link.LinkPreviewDto
import com.ekoapp.ekosdk.internal.api.dto.ChatSettingsDto
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto
import com.ekoapp.ekosdk.internal.api.dto.SocialNetworkSettingsDto
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.POST
import retrofit2.http.Query

interface NetworkSettingsApi {

    @GET("api/v3/network-settings/chat")
    fun getChatSettings(): Single<ChatSettingsDto>

    @GET("api/v3/network-settings/social")
    fun getSocialSettings(): Single<SocialNetworkSettingsDto>

    @GET("api/v3/network-settings/users")
    fun getCoreUserSettings(): Single<UserSettingsDto>

    @POST("api/v3/allowlists/verify")
    fun validateUrls(@Body request: ValidateUrlsRequest): Single<EkoDeletionDto>

    @POST("api/v3/blocklists/verify")
    fun validateTexts(@Body request: ValidateTextsRequest): Single<EkoDeletionDto>

    @GET("api/v1/link-preview")
    fun getLinkPreviewMetadata(@Query("url") url: String): Single<LinkPreviewDto>

}