package com.amity.socialcloud.sdk.core.data.room

import com.amity.socialcloud.sdk.common.EntityMapper
import com.amity.socialcloud.sdk.dto.video.RoomModerationDto
import com.amity.socialcloud.sdk.dto.video.EkoRoomModerationLabelDto
import com.amity.socialcloud.sdk.entity.video.room.RoomModerationEntity
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import org.joda.time.DateTime

internal class RoomModerationEntityMapper : EntityMapper<RoomModerationDto, RoomModerationEntity>() {

    override fun map(list: List<RoomModerationDto>): List<RoomModerationEntity> = list.map { map(it) }

    private fun map(dto: RoomModerationDto): RoomModerationEntity {
        return RoomModerationEntity().apply {
            moderationId = dto.moderationId
            // DTO uses streamId naming; map to roomId in entity
            roomId = dto.streamId
            flagLabels = toJsonArray(dto.flagLabels)
            terminateLabels = toJsonArray(dto.terminateLabels)
            dto.createdAt?.let { setCreatedAt(DateTime(it)) }
            dto.updatedAt?.let { setUpdatedAt(DateTime(it)) }
        }
    }

    private fun toJsonArray(labels: List<EkoRoomModerationLabelDto>?): JsonArray? {
        if (labels == null) return null
        val array = JsonArray()
        labels.forEach { label ->
            val obj = JsonObject().apply {
                addProperty("category", label.category)
                label.threshold?.let { addProperty("threshold", it) }
                // Persist detectedAt as epoch millis to align with RoomModerationModelMapper expectation
                label.detectedAt?.let { addProperty("detectedAt", it.time) }
            }
            array.add(obj)
        }
        return array
    }
}
