/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoReactionDao;
import com.ekoapp.ekosdk.internal.data.model.EkoReactionEntity;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoReactionDao_Impl
extends EkoReactionDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoReactionEntity> __insertAdapterOfEkoReactionEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoReactionEntity> __deleteAdapterOfEkoReactionEntity;
    private final EntityDeleteOrUpdateAdapter<EkoReactionEntity> __updateAdapterOfEkoReactionEntity;

    public EkoReactionDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoReactionEntity = new EntityInsertAdapter<EkoReactionEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `reaction` (`reactionId`,`reactionName`,`userId`,`referenceId`,`referenceType`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoReactionEntity entity) {
                if (entity.getReactionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getReactionId());
                }
                if (entity.getReactionName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getReactionName());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getUserId());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getReferenceId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getReferenceType());
                }
                String _tmp = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                String _tmp_1 = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                String _tmp_2 = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfEkoReactionEntity = new EntityDeleteOrUpdateAdapter<EkoReactionEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `reaction` WHERE `userId` = ? AND `reactionName` = ? AND `referenceType` = ? AND `referenceId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoReactionEntity entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getReactionName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getReactionName());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getReferenceType());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getReferenceId());
                }
            }
        };
        this.__updateAdapterOfEkoReactionEntity = new EntityDeleteOrUpdateAdapter<EkoReactionEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `reaction` SET `reactionId` = ?,`reactionName` = ?,`userId` = ?,`referenceId` = ?,`referenceType` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `userId` = ? AND `reactionName` = ? AND `referenceType` = ? AND `referenceId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, EkoReactionEntity entity) {
                if (entity.getReactionId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getReactionId());
                }
                if (entity.getReactionName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getReactionName());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getUserId());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getReferenceId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getReferenceType());
                }
                String _tmp = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                String _tmp_1 = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                String _tmp_2 = EkoReactionDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getUserId());
                }
                if (entity.getReactionName() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getReactionName());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getReferenceType());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getReferenceId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoReactionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoReactionEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoReactionEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoReactionEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoReactionEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoReactionEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoReactionEntity reaction) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoReactionEntity.handle(_connection, (Object)reaction);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoReactionEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoReactionEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoReactionEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoReactionDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoReactionEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoReactionDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoReactionEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoReactionDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    Maybe<EkoReactionEntity> getReactionByReferenceAndReactionNameImpl(String referenceType, String referenceId, String reactionName, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ? and reaction.reactionName = ? LIMIT 1";
        return RxRoom.createMaybe((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ? and reaction.reactionName = ? LIMIT 1");){
                EkoReactionEntity _result;
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 4;
                if (reactionName == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, reactionName);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _result.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _result.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoReactionEntity ekoReactionEntity = _result;
                return ekoReactionEntity;
            }
        });
    }

    @Override
    List<EkoReactionEntity> getAllMyReactionsByReferenceTypeAndReferenceIdNowImpl(String referenceType, String referenceId, String userId) {
        String _sql = "SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.referenceType = ? and reaction.referenceId = ? and reaction.userId = ?");){
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>();
                while (_stmt.step()) {
                    EkoReactionEntity _item = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _item.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _item.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _item.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _item.setReferenceType(_tmpReferenceType);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoReactionEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public List<EkoReactionEntity> getAllByReferenceTypeAndReferenceId(String referenceType, String referenceId) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? order by reaction.createdAt DESC");){
                int _argIndex = 1;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 2;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>();
                while (_stmt.step()) {
                    EkoReactionEntity _item = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _item.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _item.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _item.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _item.setReferenceType(_tmpReferenceType);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoReactionEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public List<EkoReactionEntity> getAllAfterReactionId(String reactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId >= ? order by reaction.createdAt DESC";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.reactionId >= ? order by reaction.createdAt DESC");){
                int _argIndex = 1;
                if (reactionId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, reactionId);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>();
                while (_stmt.step()) {
                    EkoReactionEntity _item = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _item.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _item.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _item.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _item.setReferenceType(_tmpReferenceType);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoReactionEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public List<EkoReactionEntity> getAllBeforeReactionId(String reactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId < ? order by reaction.createdAt DESC";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.reactionId < ? order by reaction.createdAt DESC");){
                int _argIndex = 1;
                if (reactionId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, reactionId);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>();
                while (_stmt.step()) {
                    EkoReactionEntity _item = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _item.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _item.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _item.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _item.setReferenceType(_tmpReferenceType);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoReactionEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public List<EkoReactionEntity> getAllBetweenReactionId(String fromReactionId, String tillReactionId) {
        String _sql = "SELECT * from reaction where reaction.reactionId BETWEEN ? and ? and reaction.reactionId != ? order by reaction.createdAt DESC";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.reactionId BETWEEN ? and ? and reaction.reactionId != ? order by reaction.createdAt DESC");){
                int _argIndex = 1;
                if (fromReactionId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, fromReactionId);
                }
                _argIndex = 2;
                if (tillReactionId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, tillReactionId);
                }
                _argIndex = 3;
                if (tillReactionId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, tillReactionId);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoReactionEntity> _result = new ArrayList<EkoReactionEntity>();
                while (_stmt.step()) {
                    EkoReactionEntity _item = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _item.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _item.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _item.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _item.setReferenceType(_tmpReferenceType);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoReactionEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EkoReactionEntity> getLatestReactionWithoutReactionNameImpl(String referenceType, String referenceId, DateTime now) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? and reaction.createdAt > ? order by reaction.createdAt DESC limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"reaction"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? and reaction.createdAt > ? order by reaction.createdAt DESC limit 1");){
                EkoReactionEntity _result;
                int _argIndex = 1;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 2;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 3;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _result.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _result.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoReactionEntity ekoReactionEntity = _result;
                return ekoReactionEntity;
            }
        });
    }

    @Override
    public Flowable<EkoReactionEntity> getLatestReactionImpl(String referenceType, String referenceId, String reactionName, DateTime now) {
        String _sql = "SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? and reaction.reactionName = ? and reaction.createdAt > ? order by reaction.createdAt DESC limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"reaction"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from reaction where reaction.referenceId = ? and reaction.referenceType = ? and reaction.reactionName = ? and reaction.createdAt > ? order by reaction.createdAt DESC limit 1");){
                EkoReactionEntity _result;
                int _argIndex = 1;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 2;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 3;
                if (reactionName == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, reactionName);
                }
                _argIndex = 4;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                int _columnIndexOfReactionId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionId");
                int _columnIndexOfReactionName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionName");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoReactionEntity();
                    String _tmpReactionId = _stmt.isNull(_columnIndexOfReactionId) ? null : _stmt.getText(_columnIndexOfReactionId);
                    _result.setReactionId(_tmpReactionId);
                    String _tmpReactionName = _stmt.isNull(_columnIndexOfReactionName) ? null : _stmt.getText(_columnIndexOfReactionName);
                    _result.setReactionName(_tmpReactionName);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    _result.setReferenceId(_tmpReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    _result.setReferenceType(_tmpReferenceType);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoReactionEntity ekoReactionEntity = _result;
                return ekoReactionEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from reaction";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from reaction");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    void deleteByPrimaryKeyImpl(String referenceType, String referenceId, String userId, String reactionName) {
        String _sql = "DELETE from reaction where referenceType = ? and referenceId = ? and userId = ? and reactionName = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from reaction where referenceType = ? and referenceId = ? and userId = ? and reactionName = ?");){
                int _argIndex = 1;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _argIndex = 2;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 3;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 4;
                if (reactionName == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, reactionName);
                }
                _stmt.step();
                Object var7_7 = null;
                return var7_7;
            }
        });
    }

    @Override
    void deleteByReferenceIdAndUserIdImpl(String referenceId, String referenceType, String userId) {
        String _sql = "DELETE from reaction where referenceId = ? and userId = ? and referenceType = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from reaction where referenceId = ? and userId = ? and referenceType = ?");){
                int _argIndex = 1;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 3;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _stmt.step();
                Object var6_6 = null;
                return var6_6;
            }
        });
    }

    @Override
    void deleteByReferenceIdImpl(String referenceId, String referenceType) {
        String _sql = "DELETE from reaction where referenceId = ? and referenceType = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from reaction where referenceId = ? and referenceType = ?");){
                int _argIndex = 1;
                if (referenceId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceId);
                }
                _argIndex = 2;
                if (referenceType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, referenceType);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

