/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomRawQuery;
import androidx.room.RoomSQLiteQuery;
import androidx.room.RxRoom;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import androidx.sqlite.db.SimpleSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.StringListConverter;
import com.ekoapp.ekosdk.internal.data.dao.AmityCommunityCategoryQueryTokenDao;
import com.ekoapp.ekosdk.internal.data.model.EkoCommunityCategoryQueryToken;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class AmityCommunityCategoryQueryTokenDao_Impl
extends AmityCommunityCategoryQueryTokenDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoCommunityCategoryQueryToken> __insertAdapterOfEkoCommunityCategoryQueryToken;
    private final StringListConverter __stringListConverter = new StringListConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();

    public AmityCommunityCategoryQueryTokenDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoCommunityCategoryQueryToken = new EntityInsertAdapter<EkoCommunityCategoryQueryToken>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `community_category_query_token` (`sortBy`,`isDeleted`,`previous`,`next`,`pageNumber`,`ids`,`updatedAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoCommunityCategoryQueryToken entity) {
                if (entity.getSortBy() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSortBy());
                }
                int _tmp = entity.isDeleted() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                if (entity.getPrevious() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPrevious());
                }
                if (entity.getNext() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getNext());
                }
                statement.bindLong(5, (long)entity.getPageNumber());
                String _tmp_1 = AmityCommunityCategoryQueryTokenDao_Impl.this.__stringListConverter.stringListToString(entity.getIds());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = AmityCommunityCategoryQueryTokenDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
            }
        };
    }

    @Override
    public Completable insertToken(EkoCommunityCategoryQueryToken token) {
        if (token == null) {
            throw new NullPointerException();
        }
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoCommunityCategoryQueryToken.insert(_connection, (Object)token);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Maybe<EkoCommunityCategoryQueryToken> queryToken(SimpleSQLiteQuery query) {
        RoomRawQuery _rawQuery = RoomSQLiteQuery.copyFrom((SupportSQLiteQuery)query).toRoomRawQuery();
        String _sql = _rawQuery.getSql();
        return RxRoom.createMaybe((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                _rawQuery.getBindingFunction().invoke((Object)_stmt);
                EkoCommunityCategoryQueryToken _result = _stmt.step() ? this.__entityStatementConverter_comEkoappEkosdkInternalDataModelEkoCommunityCategoryQueryToken(_stmt) : null;
                EkoCommunityCategoryQueryToken ekoCommunityCategoryQueryToken = _result;
                return ekoCommunityCategoryQueryToken;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }

    private EkoCommunityCategoryQueryToken __entityStatementConverter_comEkoappEkosdkInternalDataModelEkoCommunityCategoryQueryToken(@NonNull SQLiteStatement statement) {
        int _columnIndexOfSortBy = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)statement, (String)"sortBy");
        int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)statement, (String)"isDeleted");
        int _columnIndexOfPrevious = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)statement, (String)"previous");
        int _columnIndexOfNext = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)statement, (String)"next");
        int _columnIndexOfPageNumber = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)statement, (String)"pageNumber");
        int _columnIndexOfIds = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)statement, (String)"ids");
        int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndex((SQLiteStatement)statement, (String)"updatedAt");
        EkoCommunityCategoryQueryToken _entity = new EkoCommunityCategoryQueryToken();
        if (_columnIndexOfSortBy != -1) {
            String _tmpSortBy = statement.isNull(_columnIndexOfSortBy) ? null : statement.getText(_columnIndexOfSortBy);
            _entity.setSortBy(_tmpSortBy);
        }
        if (_columnIndexOfIsDeleted != -1) {
            int _tmp = (int)statement.getLong(_columnIndexOfIsDeleted);
            boolean _tmpIsDeleted = _tmp != 0;
            _entity.setDeleted(_tmpIsDeleted);
        }
        if (_columnIndexOfPrevious != -1) {
            String _tmpPrevious = statement.isNull(_columnIndexOfPrevious) ? null : statement.getText(_columnIndexOfPrevious);
            _entity.setPrevious(_tmpPrevious);
        }
        if (_columnIndexOfNext != -1) {
            String _tmpNext = statement.isNull(_columnIndexOfNext) ? null : statement.getText(_columnIndexOfNext);
            _entity.setNext(_tmpNext);
        }
        if (_columnIndexOfPageNumber != -1) {
            int _tmpPageNumber = (int)statement.getLong(_columnIndexOfPageNumber);
            _entity.setPageNumber(_tmpPageNumber);
        }
        if (_columnIndexOfIds != -1) {
            String _tmp_1 = statement.isNull(_columnIndexOfIds) ? null : statement.getText(_columnIndexOfIds);
            List<String> _tmpIds = this.__stringListConverter.stringToStringList(_tmp_1);
            _entity.setIds(_tmpIds);
        }
        if (_columnIndexOfUpdatedAt != -1) {
            String _tmp_2 = statement.isNull(_columnIndexOfUpdatedAt) ? null : statement.getText(_columnIndexOfUpdatedAt);
            DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
            _entity.setUpdatedAt(_tmpUpdatedAt);
        }
        return _entity;
    }
}

