package com.amity.socialcloud.sdk.core.data.notificationtray

import com.amity.socialcloud.sdk.dto.core.notificationtray.MarkItemSeenDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.MarkTraySeenDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTrayItemSeenRequest
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTrayQueryDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTraySeenDto
import com.amity.socialcloud.sdk.dto.core.notificationtray.NotificationTraySeenRequest
import com.amity.socialcloud.sdk.dto.core.notificationtray.TrayItemRequest
import com.ekoapp.ekosdk.internal.api.AmityHttpClient
import io.reactivex.rxjava3.core.Single
import org.joda.time.DateTime

class NotificationTrayRemoteDataStore {
    fun getNotificationTrayItems(
        limit: Int? = null,
        token: String? = null,
    ): Single<NotificationTrayQueryDto> {
        return AmityHttpClient.get(NotificationTrayApi::class).flatMap {
            it.queryNotificationTrayItems(
                limit = limit, token = token
            )
        }
    }

    fun getNotificationTraySeen(): Single<NotificationTraySeenDto> {
        return AmityHttpClient.get(NotificationTrayApi::class).flatMap {
            it.getNotificationTraySeen()
        }
    }

    fun markTraySeen(): Single<MarkTraySeenDto> {
        return AmityHttpClient.get(NotificationTrayApi::class).flatMap {
            it.markNotificationTrayAsSeen(
                request = NotificationTraySeenRequest(
                    lastSeenAt = DateTime.now()
                )
            )
        }
    }

    fun markTrayItemSeen(notiTrayItemId: String): Single<MarkItemSeenDto> {
        return AmityHttpClient.get(NotificationTrayApi::class).flatMap {
            it.markNotificationItemsAsSeen(
                request = NotificationTrayItemSeenRequest(
                    trayItems = listOf(
                        TrayItemRequest(
                            id = notiTrayItemId,
                            lastSeenAt = DateTime.now()
                        )
                    )
                )
            )
        }
    }
}