/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.push;

import android.util.Pair;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.push.EkoPushContract;
import com.ekoapp.ekosdk.internal.api.AmityHttpClient;
import com.ekoapp.ekosdk.internal.api.EkoNotificationApi;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.api.http.request.RegisterDeviceForPushNotificationResponse;
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationRequest;
import com.ekoapp.ekosdk.internal.api.http.request.UnregisterDeviceForPushNotificationResponse;
import com.ekoapp.ekosdk.internal.data.EkoDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey;
import com.ekoapp.ekosdk.internal.data.model.EkoBaiduToken;
import com.ekoapp.ekosdk.internal.data.model.EkoFcmToken;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import com.ekoapp.ekosdk.internal.push.EkoPushContractImpl;
import com.github.davidmoten.guavamini.Objects;
import com.google.gson.Gson;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.functions.BiPredicate;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Function3;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0003\"#$B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bR\u00020\u00000\nH\u0002J\u001a\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bR\u00020\u00000\nH\u0002J0\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bR\u00020\u00002\u0012\u0010\u0012\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bR\u00020\u0000H\u0002J\u001c\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bR\u00020\u0000H\u0002J\u001c\u0010\u0015\u001a\u00020\u00102\u0012\u0010\u0014\u001a\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000bR\u00020\u0000H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J&\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\b\u0010\u001a\u001a\u0004\u0018\u00010\u00052\b\u0010\u001b\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\nH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ekoapp/ekosdk/internal/push/EkoPushContractImpl;", "Lcom/amity/socialcloud/sdk/push/EkoPushContract;", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "initPushService", "", "initFcm", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/ekoapp/ekosdk/internal/push/EkoPushContractImpl$TokenConfigAndApiKey;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoFcmToken;", "initBaidu", "Lcom/ekoapp/ekosdk/internal/data/model/EkoBaiduToken;", "prioritizeFcmToken", "Lio/reactivex/rxjava3/core/Completable;", "fcmConfig", "baiduConfig", "handleFcmToken", "tokenConfigAndApiKey", "handleBaiduToken", "insertBaiduApiKey", "apiKey", "updateBaiduToken", "token", "userId", "channelId", "insertFcmToken", "fcmToken", "hasRegisteredConfig", "", "getPushConfig", "Lcom/ekoapp/ekosdk/internal/data/model/EkoPushConfig;", "Provider", "TokenConfigAndApiKey", "Companion", "amity-sdk_release"})
public final class EkoPushContractImpl
implements EkoPushContract {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final String TAG = this.getClass().getName();

    public EkoPushContractImpl() {
        this.initPushService();
    }

    private final void initPushService() {
        Flowable.combineLatest((Publisher)((Publisher)this.initFcm().startWithItem(new TokenConfigAndApiKey<Object>(null, null, null))), (Publisher)((Publisher)this.initBaidu().startWithItem(new TokenConfigAndApiKey<Object>(null, null, null))), (BiFunction)initPushService.1.INSTANCE).skip(1L).flatMapCompletable(new Function(this){
            final /* synthetic */ EkoPushContractImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(Pair<TokenConfigAndApiKey<EkoFcmToken>, TokenConfigAndApiKey<EkoBaiduToken>> configPair) {
                Object object;
                Object baiduState;
                Object object2;
                Object fcmState;
                Intrinsics.checkNotNullParameter(configPair, (String)"configPair");
                TokenConfigAndApiKey fcmConfig = (TokenConfigAndApiKey)configPair.first;
                Object object3 = fcmConfig.getConfig();
                if (object3 == null || (object3 = ((EkoPushConfig)object3).getState()) == null || (object3 = ((EkoPushConfig.State)((Object)object3)).getApiKey()) == null) {
                    object3 = fcmState = "null";
                }
                if ((object2 = (EkoFcmToken)fcmConfig.getToken()) == null || (object2 = ((EkoFcmToken)object2).getToken()) == null) {
                    object2 = "null";
                }
                Object fcmToken = object2;
                AmityLog.INSTANCE.e("fcm: " + (String)fcmState + " token:" + (String)fcmToken, new Object[0]);
                TokenConfigAndApiKey baiduConfig = (TokenConfigAndApiKey)configPair.second;
                Object object4 = baiduConfig.getConfig();
                if (object4 == null || (object4 = ((EkoPushConfig)object4).getState()) == null || (object4 = ((EkoPushConfig.State)((Object)object4)).getApiKey()) == null) {
                    object4 = baiduState = "null";
                }
                if ((object = (EkoBaiduToken)baiduConfig.getToken()) == null || (object = ((EkoBaiduToken)object).getToken()) == null) {
                    object = "null";
                }
                Object baiduToken = object;
                AmityLog.INSTANCE.e("baidu: " + (String)baiduState + " token:" + (String)baiduToken, new Object[0]);
                if (fcmConfig.getToken() != null && baiduConfig.getToken() != null) {
                    Intrinsics.checkNotNull((Object)fcmConfig);
                    Intrinsics.checkNotNull((Object)baiduConfig);
                    return (CompletableSource)EkoPushContractImpl.access$prioritizeFcmToken(this.this$0, fcmConfig, baiduConfig);
                }
                if (fcmConfig.getToken() != null) {
                    Intrinsics.checkNotNull((Object)fcmConfig);
                    return (CompletableSource)EkoPushContractImpl.access$handleFcmToken(this.this$0, fcmConfig);
                }
                Intrinsics.checkNotNull((Object)baiduConfig);
                return (CompletableSource)EkoPushContractImpl.access$handleBaiduToken(this.this$0, baiduConfig);
            }
        }).subscribeOn(Schedulers.io()).onErrorComplete().subscribe();
    }

    private final Flowable<TokenConfigAndApiKey<EkoFcmToken>> initFcm() {
        Flowable flowable = Flowable.combineLatest((Publisher)((Publisher)EkoDatabase.get().fcmTokenDao().getFcmToken().distinctUntilChanged((BiPredicate)initFcm.1.INSTANCE)), (Publisher)((Publisher)this.getPushConfig()), (Publisher)((Publisher)EkoPushContractImpl.Companion.getApiKey()), (Function3)new Function3(this){
            final /* synthetic */ EkoPushContractImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final TokenConfigAndApiKey<EkoFcmToken> apply(EkoFcmToken token, EkoPushConfig config, EkoApiKey apiKey) {
                Intrinsics.checkNotNullParameter((Object)token, (String)"token");
                return this.this$0.new TokenConfigAndApiKey<EkoFcmToken>(token, config, apiKey);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"combineLatest(...)");
        return flowable;
    }

    private final Flowable<TokenConfigAndApiKey<EkoBaiduToken>> initBaidu() {
        Flowable flowable = Flowable.combineLatest((Publisher)((Publisher)EkoDatabase.get().baiduTokenDao().getBaiduToken().distinctUntilChanged((BiPredicate)initBaidu.1.INSTANCE)), (Publisher)((Publisher)this.getPushConfig()), (Publisher)((Publisher)EkoPushContractImpl.Companion.getApiKey()), (Function3)new Function3(this){
            final /* synthetic */ EkoPushContractImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final TokenConfigAndApiKey<EkoBaiduToken> apply(EkoBaiduToken token, EkoPushConfig config, EkoApiKey apiKey) {
                return this.this$0.new TokenConfigAndApiKey<EkoBaiduToken>(token, config, apiKey);
            }
        }).filter((Predicate)initBaidu.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"filter(...)");
        return flowable;
    }

    private final Completable prioritizeFcmToken(TokenConfigAndApiKey<EkoFcmToken> fcmConfig, TokenConfigAndApiKey<EkoBaiduToken> baiduConfig) {
        Completable completable;
        EkoPushConfig ekoPushConfig = fcmConfig.getConfig();
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)(ekoPushConfig != null ? ekoPushConfig.getState() : null)))) {
            EkoPushConfig ekoPushConfig2 = fcmConfig.getConfig();
            String string = ekoPushConfig2 != null ? ekoPushConfig2.getUserId() : null;
            EkoPushConfig ekoPushConfig3 = fcmConfig.getConfig();
            String string2 = ekoPushConfig3 != null ? ekoPushConfig3.getDeviceId() : null;
            EkoFcmToken ekoFcmToken = fcmConfig.getToken();
            String string3 = ekoFcmToken != null ? ekoFcmToken.getToken() : null;
            Intrinsics.checkNotNull((Object)string3);
            RegisterDeviceForPushNotificationRequest registerRequest = RegisterDeviceForPushNotificationRequest.Companion.create(string, string2, string3, Provider.FCM.getApiKey());
            EkoPushConfig ekoPushConfig4 = baiduConfig.getConfig();
            EkoPushConfig ekoPushConfig5 = baiduConfig.getConfig();
            UnregisterDeviceForPushNotificationRequest unregisterRequest = UnregisterDeviceForPushNotificationRequest.Companion.create(ekoPushConfig4 != null ? ekoPushConfig4.getUserId() : null, ekoPushConfig5 != null ? ekoPushConfig5.getDeviceId() : null);
            Completable completable2 = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).flatMap(new Function(baiduConfig, unregisterRequest){
                final /* synthetic */ TokenConfigAndApiKey<EkoBaiduToken> $baiduConfig;
                final /* synthetic */ UnregisterDeviceForPushNotificationRequest $unregisterRequest;
                {
                    this.$baiduConfig = $baiduConfig;
                    this.$unregisterRequest = $unregisterRequest;
                }

                public final SingleSource<? extends UnregisterDeviceForPushNotificationResponse> apply(EkoNotificationApi it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EkoApiKey ekoApiKey = this.$baiduConfig.getApiKey();
                    Intrinsics.checkNotNull((Object)ekoApiKey);
                    return (SingleSource)it.unregisterNotificationToken(ekoApiKey.getApiKey(), this.$unregisterRequest);
                }
            }).ignoreElement().andThen((CompletableSource)AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).flatMap(new Function(fcmConfig, registerRequest){
                final /* synthetic */ TokenConfigAndApiKey<EkoFcmToken> $fcmConfig;
                final /* synthetic */ RegisterDeviceForPushNotificationRequest $registerRequest;
                {
                    this.$fcmConfig = $fcmConfig;
                    this.$registerRequest = $registerRequest;
                }

                public final SingleSource<? extends RegisterDeviceForPushNotificationResponse> apply(EkoNotificationApi it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EkoApiKey ekoApiKey = this.$fcmConfig.getApiKey();
                    Intrinsics.checkNotNull((Object)ekoApiKey);
                    return (SingleSource)it.registerNotificationToken(ekoApiKey.getApiKey(), this.$registerRequest);
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ EkoPushContractImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(RegisterDeviceForPushNotificationResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    String string = EkoPushContractImpl.access$getTAG$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$p(...)");
                    AmityLog amityLog = AmityLog.INSTANCE.tag(string);
                    String string2 = "fcm response:%s";
                    Object[] objectArray = new Object[]{new Gson().toJson((Object)response)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    amityLog.i(string3, new Object[0]);
                }
            }).ignoreElement().onErrorComplete()).onErrorComplete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            EkoPushConfig ekoPushConfig6 = fcmConfig.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig6);
            String string = ekoPushConfig6.getUserId();
            EkoPushConfig ekoPushConfig7 = fcmConfig.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig7);
            UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.Companion.create(string, ekoPushConfig7.getDeviceId());
            String string4 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"TAG");
            AmityLog amityLog = AmityLog.INSTANCE.tag(string4);
            String string5 = "fcm un-registration request:%s";
            Object[] objectArray = new Object[]{new Gson().toJson((Object)request)};
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
            amityLog.i(string6, new Object[0]);
            Completable completable3 = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).flatMap(new Function(fcmConfig, request){
                final /* synthetic */ TokenConfigAndApiKey<EkoFcmToken> $fcmConfig;
                final /* synthetic */ UnregisterDeviceForPushNotificationRequest $request;
                {
                    this.$fcmConfig = $fcmConfig;
                    this.$request = $request;
                }

                public final SingleSource<? extends UnregisterDeviceForPushNotificationResponse> apply(EkoNotificationApi it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EkoApiKey ekoApiKey = this.$fcmConfig.getApiKey();
                    Intrinsics.checkNotNull((Object)ekoApiKey);
                    return (SingleSource)it.unregisterNotificationToken(ekoApiKey.getApiKey(), this.$request);
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ EkoPushContractImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(UnregisterDeviceForPushNotificationResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    String string = EkoPushContractImpl.access$getTAG$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$p(...)");
                    AmityLog amityLog = AmityLog.INSTANCE.tag(string);
                    String string2 = "fcm response:%s";
                    Object[] objectArray = new Object[]{new Gson().toJson((Object)response)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    amityLog.i(string3, new Object[0]);
                }
            }).ignoreElement().onErrorComplete();
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    private final Completable handleFcmToken(TokenConfigAndApiKey<EkoFcmToken> tokenConfigAndApiKey) {
        Completable completable;
        EkoPushConfig ekoPushConfig = tokenConfigAndApiKey.getConfig();
        Intrinsics.checkNotNull((Object)ekoPushConfig);
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)ekoPushConfig.getState()))) {
            EkoPushConfig ekoPushConfig2 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig2);
            String string = ekoPushConfig2.getUserId();
            EkoPushConfig ekoPushConfig3 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig3);
            String string2 = ekoPushConfig3.getDeviceId();
            EkoFcmToken ekoFcmToken = tokenConfigAndApiKey.getToken();
            Intrinsics.checkNotNull((Object)ekoFcmToken);
            RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.Companion.create(string, string2, ekoFcmToken.getToken(), Provider.FCM.getApiKey());
            String string3 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"TAG");
            AmityLog amityLog = AmityLog.INSTANCE.tag(string3);
            String string4 = "fcm registration request:%s";
            Object[] objectArray = new Object[]{new Gson().toJson((Object)request)};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            amityLog.i(string5, new Object[0]);
            Completable completable2 = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).flatMap(new Function(tokenConfigAndApiKey, request){
                final /* synthetic */ TokenConfigAndApiKey<EkoFcmToken> $tokenConfigAndApiKey;
                final /* synthetic */ RegisterDeviceForPushNotificationRequest $request;
                {
                    this.$tokenConfigAndApiKey = $tokenConfigAndApiKey;
                    this.$request = $request;
                }

                public final SingleSource<? extends RegisterDeviceForPushNotificationResponse> apply(EkoNotificationApi it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EkoApiKey ekoApiKey = this.$tokenConfigAndApiKey.getApiKey();
                    Intrinsics.checkNotNull((Object)ekoApiKey);
                    return (SingleSource)it.registerNotificationToken(ekoApiKey.getApiKey(), this.$request);
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ EkoPushContractImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(RegisterDeviceForPushNotificationResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    String string = EkoPushContractImpl.access$getTAG$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$p(...)");
                    AmityLog amityLog = AmityLog.INSTANCE.tag(string);
                    String string2 = "fcm response:%s";
                    Object[] objectArray = new Object[]{new Gson().toJson((Object)response)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    amityLog.i(string3, new Object[0]);
                }
            }).ignoreElement().onErrorComplete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            EkoPushConfig ekoPushConfig4 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig4);
            String userId = ekoPushConfig4.getUserId();
            EkoPushConfig ekoPushConfig5 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig5);
            String string = ekoPushConfig5.getUserId();
            EkoPushConfig ekoPushConfig6 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig6);
            UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.Companion.create(string, ekoPushConfig6.getDeviceId());
            String string6 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"TAG");
            AmityLog amityLog = AmityLog.INSTANCE.tag(string6);
            String string7 = "fcm un-registration request:%s";
            Object[] objectArray = new Object[]{new Gson().toJson((Object)request)};
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
            amityLog.i(string8, new Object[0]);
            Completable completable3 = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).flatMap(new Function(tokenConfigAndApiKey, request){
                final /* synthetic */ TokenConfigAndApiKey<EkoFcmToken> $tokenConfigAndApiKey;
                final /* synthetic */ UnregisterDeviceForPushNotificationRequest $request;
                {
                    this.$tokenConfigAndApiKey = $tokenConfigAndApiKey;
                    this.$request = $request;
                }

                public final SingleSource<? extends UnregisterDeviceForPushNotificationResponse> apply(EkoNotificationApi it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EkoApiKey ekoApiKey = this.$tokenConfigAndApiKey.getApiKey();
                    Intrinsics.checkNotNull((Object)ekoApiKey);
                    return (SingleSource)it.unregisterNotificationToken(ekoApiKey.getApiKey(), this.$request);
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ EkoPushContractImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(UnregisterDeviceForPushNotificationResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    String string = EkoPushContractImpl.access$getTAG$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$p(...)");
                    AmityLog amityLog = AmityLog.INSTANCE.tag(string);
                    String string2 = "fcm response:%s";
                    Object[] objectArray = new Object[]{new Gson().toJson((Object)response)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    amityLog.i(string3, new Object[0]);
                }
            }).ignoreElement().andThen((CompletableSource)Completable.fromAction(() -> EkoPushContractImpl.handleFcmToken$lambda$0(userId))).onErrorComplete();
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    private final Completable handleBaiduToken(TokenConfigAndApiKey<EkoBaiduToken> tokenConfigAndApiKey) {
        Completable completable;
        EkoPushConfig ekoPushConfig = tokenConfigAndApiKey.getConfig();
        Intrinsics.checkNotNull((Object)ekoPushConfig);
        if (Objects.equal((Object)((Object)EkoPushConfig.State.REGISTERED), (Object)((Object)ekoPushConfig.getState()))) {
            EkoPushConfig ekoPushConfig2 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig2);
            String string = ekoPushConfig2.getUserId();
            EkoPushConfig ekoPushConfig3 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig3);
            String string2 = ekoPushConfig3.getDeviceId();
            Gson gson = new Gson();
            EkoBaiduToken ekoBaiduToken = tokenConfigAndApiKey.getToken();
            Intrinsics.checkNotNull((Object)ekoBaiduToken);
            String string3 = ekoBaiduToken.getToken();
            EkoBaiduToken ekoBaiduToken2 = tokenConfigAndApiKey.getToken();
            Intrinsics.checkNotNull((Object)ekoBaiduToken2);
            String string4 = ekoBaiduToken2.getUserId();
            EkoBaiduToken ekoBaiduToken3 = tokenConfigAndApiKey.getToken();
            Intrinsics.checkNotNull((Object)ekoBaiduToken3);
            String string5 = gson.toJson((Object)new RegisterDeviceForPushNotificationRequest.BaiduToken(string3, string4, ekoBaiduToken3.getChannelId()));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toJson(...)");
            RegisterDeviceForPushNotificationRequest request = RegisterDeviceForPushNotificationRequest.Companion.create(string, string2, string5, Provider.BAIDU.getApiKey());
            String string6 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"TAG");
            AmityLog amityLog = AmityLog.INSTANCE.tag(string6);
            String string7 = "baidu registration request:%s";
            Object[] objectArray = new Object[]{new Gson().toJson((Object)request)};
            String string8 = String.format(string7, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(...)");
            amityLog.i(string8, new Object[0]);
            Completable completable2 = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).flatMap(new Function(tokenConfigAndApiKey, request){
                final /* synthetic */ TokenConfigAndApiKey<EkoBaiduToken> $tokenConfigAndApiKey;
                final /* synthetic */ RegisterDeviceForPushNotificationRequest $request;
                {
                    this.$tokenConfigAndApiKey = $tokenConfigAndApiKey;
                    this.$request = $request;
                }

                public final SingleSource<? extends RegisterDeviceForPushNotificationResponse> apply(EkoNotificationApi it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EkoApiKey ekoApiKey = this.$tokenConfigAndApiKey.getApiKey();
                    Intrinsics.checkNotNull((Object)ekoApiKey);
                    return (SingleSource)it.registerNotificationToken(ekoApiKey.getApiKey(), this.$request);
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ EkoPushContractImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(RegisterDeviceForPushNotificationResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    String string = EkoPushContractImpl.access$getTAG$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$p(...)");
                    AmityLog amityLog = AmityLog.INSTANCE.tag(string);
                    String string2 = "baidu response:%s";
                    Object[] objectArray = new Object[]{new Gson().toJson((Object)response)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    amityLog.i(string3, new Object[0]);
                }
            }).ignoreElement().onErrorComplete();
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else {
            EkoPushConfig ekoPushConfig4 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig4);
            String string = ekoPushConfig4.getUserId();
            EkoPushConfig ekoPushConfig5 = tokenConfigAndApiKey.getConfig();
            Intrinsics.checkNotNull((Object)ekoPushConfig5);
            UnregisterDeviceForPushNotificationRequest request = UnregisterDeviceForPushNotificationRequest.Companion.create(string, ekoPushConfig5.getDeviceId());
            String string9 = this.TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"TAG");
            AmityLog amityLog = AmityLog.INSTANCE.tag(string9);
            String string10 = "baidu un-registration request:%s";
            Object[] objectArray = new Object[]{new Gson().toJson((Object)request)};
            String string11 = String.format(string10, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
            amityLog.i(string11, new Object[0]);
            Completable completable3 = AmityHttpClient.Companion.get(Reflection.getOrCreateKotlinClass(EkoNotificationApi.class)).flatMap(new Function(tokenConfigAndApiKey, request){
                final /* synthetic */ TokenConfigAndApiKey<EkoBaiduToken> $tokenConfigAndApiKey;
                final /* synthetic */ UnregisterDeviceForPushNotificationRequest $request;
                {
                    this.$tokenConfigAndApiKey = $tokenConfigAndApiKey;
                    this.$request = $request;
                }

                public final SingleSource<? extends UnregisterDeviceForPushNotificationResponse> apply(EkoNotificationApi it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    EkoApiKey ekoApiKey = this.$tokenConfigAndApiKey.getApiKey();
                    Intrinsics.checkNotNull((Object)ekoApiKey);
                    return (SingleSource)it.unregisterNotificationToken(ekoApiKey.getApiKey(), this.$request);
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ EkoPushContractImpl this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(UnregisterDeviceForPushNotificationResponse response) {
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    String string = EkoPushContractImpl.access$getTAG$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"access$getTAG$p(...)");
                    AmityLog amityLog = AmityLog.INSTANCE.tag(string);
                    String string2 = "baidu response:%s";
                    Object[] objectArray = new Object[]{new Gson().toJson((Object)response)};
                    String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                    amityLog.i(string3, new Object[0]);
                }
            }).ignoreElement().onErrorComplete();
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    @NotNull
    public Completable insertBaiduApiKey(@NotNull String apiKey) {
        Intrinsics.checkNotNullParameter((Object)apiKey, (String)"apiKey");
        Completable completable = Completable.fromAction(() -> EkoPushContractImpl.insertBaiduApiKey$lambda$1(apiKey));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public Completable updateBaiduToken(@Nullable String token, @Nullable String userId, @Nullable String channelId) {
        Completable completable = Completable.fromAction(() -> EkoPushContractImpl.updateBaiduToken$lambda$2(token, userId, channelId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public Completable insertFcmToken(@NotNull String fcmToken) {
        Intrinsics.checkNotNullParameter((Object)fcmToken, (String)"fcmToken");
        Completable completable = Completable.fromAction(() -> EkoPushContractImpl.insertFcmToken$lambda$3(fcmToken));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public Flowable<Boolean> hasRegisteredConfig() {
        Flowable<Boolean> flowable = EkoDatabase.get().pushConfigDao().hasRegisteredConfig();
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"hasRegisteredConfig(...)");
        return flowable;
    }

    private final Flowable<EkoPushConfig> getPushConfig() {
        Flowable flowable = EkoDatabase.get().accountDao().getAll().flatMapIterable((Function)getPushConfig.1.INSTANCE).distinct((Function)getPushConfig.2.INSTANCE).flatMap((Function)getPushConfig.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"flatMap(...)");
        return flowable;
    }

    private static final void handleFcmToken$lambda$0(String $userId) {
        EkoDatabase.get().pushConfigDao().clearUnregisteredPushConfigForUser($userId);
    }

    private static final void insertBaiduApiKey$lambda$1(String $apiKey) {
        EkoDatabase.get().baiduTokenDao().insertOrUpdate(new EkoBaiduToken($apiKey));
    }

    private static final void updateBaiduToken$lambda$2(String $token, String $userId, String $channelId) {
        EkoDatabase.get().baiduTokenDao().updateToken($token, $userId, $channelId);
    }

    private static final void insertFcmToken$lambda$3(String $fcmToken) {
        EkoDatabase.get().fcmTokenDao().insert(new EkoFcmToken($fcmToken));
    }

    public static final /* synthetic */ Completable access$prioritizeFcmToken(EkoPushContractImpl $this, TokenConfigAndApiKey fcmConfig, TokenConfigAndApiKey baiduConfig) {
        return $this.prioritizeFcmToken(fcmConfig, baiduConfig);
    }

    public static final /* synthetic */ Completable access$handleFcmToken(EkoPushContractImpl $this, TokenConfigAndApiKey tokenConfigAndApiKey) {
        return $this.handleFcmToken(tokenConfigAndApiKey);
    }

    public static final /* synthetic */ Completable access$handleBaiduToken(EkoPushContractImpl $this, TokenConfigAndApiKey tokenConfigAndApiKey) {
        return $this.handleBaiduToken(tokenConfigAndApiKey);
    }

    public static final /* synthetic */ String access$getTAG$p(EkoPushContractImpl $this) {
        return $this.TAG;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/ekoapp/ekosdk/internal/push/EkoPushContractImpl$Companion;", "", "<init>", "()V", "getApiKey", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        private final Flowable<EkoApiKey> getApiKey() {
            Flowable<EkoApiKey> flowable = EkoDatabase.get().apiKeyDao().getCurrentApiKeyFlowable();
            Intrinsics.checkNotNullExpressionValue(flowable, (String)"getCurrentApiKeyFlowable(...)");
            return flowable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0080\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/ekoapp/ekosdk/internal/push/EkoPushContractImpl$Provider;", "", "apiKey", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getApiKey", "()Ljava/lang/String;", "FCM", "BAIDU", "amity-sdk_release"})
    public static final class Provider
    extends Enum<Provider> {
        @NotNull
        private final String apiKey;
        public static final /* enum */ Provider FCM = new Provider("fcm");
        public static final /* enum */ Provider BAIDU = new Provider("baidu");
        private static final /* synthetic */ Provider[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Provider(String apiKey) {
            this.apiKey = apiKey;
        }

        @NotNull
        public final String getApiKey() {
            return this.apiKey;
        }

        public static Provider[] values() {
            return (Provider[])$VALUES.clone();
        }

        public static Provider valueOf(String value) {
            return Enum.valueOf(Provider.class, value);
        }

        @NotNull
        public static EnumEntries<Provider> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = providerArray = new Provider[]{Provider.FCM, Provider.BAIDU};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0080\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u001c\u0010\u0003\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000e\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/ekoapp/ekosdk/internal/push/EkoPushContractImpl$TokenConfigAndApiKey;", "TOKEN", "", "token", "config", "Lcom/ekoapp/ekosdk/internal/data/model/EkoPushConfig;", "apiKey", "Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;", "<init>", "(Lcom/ekoapp/ekosdk/internal/push/EkoPushContractImpl;Ljava/lang/Object;Lcom/ekoapp/ekosdk/internal/data/model/EkoPushConfig;Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;)V", "getToken", "()Ljava/lang/Object;", "setToken", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getConfig", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoPushConfig;", "setConfig", "(Lcom/ekoapp/ekosdk/internal/data/model/EkoPushConfig;)V", "getApiKey", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;", "setApiKey", "(Lcom/ekoapp/ekosdk/internal/data/model/EkoApiKey;)V", "amity-sdk_release"})
    public final class TokenConfigAndApiKey<TOKEN> {
        private TOKEN token;
        @Nullable
        private EkoPushConfig config;
        @Nullable
        private EkoApiKey apiKey;

        public TokenConfigAndApiKey(@Nullable TOKEN token, @Nullable EkoPushConfig config, EkoApiKey apiKey) {
            this.token = token;
            this.config = config;
            this.apiKey = apiKey;
        }

        public final TOKEN getToken() {
            return this.token;
        }

        public final void setToken(TOKEN TOKEN) {
            this.token = TOKEN;
        }

        @Nullable
        public final EkoPushConfig getConfig() {
            return this.config;
        }

        public final void setConfig(@Nullable EkoPushConfig ekoPushConfig) {
            this.config = ekoPushConfig;
        }

        @Nullable
        public final EkoApiKey getApiKey() {
            return this.apiKey;
        }

        public final void setApiKey(@Nullable EkoApiKey ekoApiKey) {
            this.apiKey = ekoApiKey;
        }
    }
}

