package com.amity.socialcloud.sdk.video.data.room

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.video.room.RoomModerationEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Flowable

@Dao
internal abstract class RoomModerationDao : EkoObjectDao<RoomModerationEntity>() {
    @Query("SELECT * FROM room_moderation WHERE moderationId = :moderationId")
    abstract fun getByIdImpl(moderationId: String): Flowable<RoomModerationEntity>
    fun getById(moderationId: String): Flowable<RoomModerationEntity> = getByIdImpl(moderationId)

    @Query("SELECT * FROM room_moderation WHERE moderationId = :moderationId")
    abstract fun getByIdNowImpl(moderationId: String): RoomModerationEntity?
    override fun getByIdNow(moderationId: String): RoomModerationEntity? = getByIdNowImpl(moderationId)

    @Query("SELECT * FROM room_moderation WHERE moderationId in (:ids)")
    abstract fun getByIdsNowImpl(ids: List<String>): List<RoomModerationEntity>
    override fun getByIdsNow(ids: List<String>): List<RoomModerationEntity> = getByIdsNowImpl(ids)

    @Query("DELETE FROM room_moderation")
    abstract override fun deleteAll()

    @Query("SELECT * FROM room_moderation WHERE roomId = :roomId LIMIT 1")
    abstract fun getByRoomIdNow(roomId: String): RoomModerationEntity?
}
