package com.amity.socialcloud.sdk.model.video.stream

import android.os.Parcelable
import com.amity.socialcloud.sdk.core.JsonObjectParceler
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.user.AmityUser
import com.amity.socialcloud.sdk.model.social.community.AmityCommunity
import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.ekoapp.ekosdk.JsonArrayParceler
import com.ekoapp.ekosdk.ReactorObject
import com.google.gson.JsonArray
import com.google.gson.JsonObject
import kotlinx.parcelize.Parcelize
import kotlinx.parcelize.TypeParceler
import org.joda.time.DateTime

@Parcelize
@TypeParceler<JsonObject?, JsonObjectParceler>
@TypeParceler<JsonArray?, JsonArrayParceler>
data class AmityStream internal constructor(private val streamId: String,
                                            internal val moderationId: String,
                                            internal var moderation: AmityStreamModeration? = null,
                                            private val status: Status = Status.IDLE,
                                            private val title: String?,
                                            private val description: String?,
                                            private val resolution: String?,
                                            internal val thumbnailId: String?,
                                            internal var thumbnailImage: AmityImage? = null,
                                            internal val watcherData: JsonObject?,
                                            private val broadcasterData: JsonObject?,
                                            internal val recordings: JsonArray?,
                                            private val userId: String,
                                            internal var user: AmityUser? = null,
                                            private val metadata: JsonObject?,
                                            private val isDeleted: Boolean,
                                            private val referenceId: String?,
                                            private val referenceType: String?,
                                            private val targetId: String?,
                                            private val targetType: String?,
                                            internal var post: AmityPost? = null,
                                            internal var community: AmityCommunity? = null,
                                            internal val postId: String? = null,
                                            internal val channelId: String? = null,
                                            internal val channelEnabled: Boolean? = null,
                                            internal var channel: AmityChannel? = null,
                                            internal var isBanned: Boolean? = null,
                                            private val isParent: Boolean,
                                            private val parentStreamId: String? = null,
                                            private val childStreamIds: List<String>,
                                            internal var childStreams: List<AmityStream>,
                                            private val createdAt: DateTime,
                                            private val updatedAt: DateTime) : Parcelable, ReactorObject {

    fun getStreamId(): String {
        return streamId
    }

    fun getStatus(): Status {
        return status
    }

    fun getTitle(): String? {
        return title
    }

    fun getDescription(): String? {
        return description
    }

    fun getResolution(): String? {
        return resolution
    }

    fun getCreatorId(): String {
        return userId
    }

    fun getCreator(): AmityUser? {
        return user
    }

    fun getThumbnailImage(): AmityImage? {
        return thumbnailImage
    }

    fun getMetaData(): JsonObject? {
        return metadata
    }

    fun getCreatedAt(): DateTime {
        return createdAt
    }

    fun getUpdatedAt(): DateTime {
        return updatedAt
    }

    fun isDeleted(): Boolean {
        return isDeleted
    }

    fun getReferenceId(): String? {
        return referenceId
    }

    fun getReferenceType(): String? {
        return referenceType
    }

    fun getTargetId(): String? {
        return targetId
    }

    fun getTargetType(): String? {
        return targetType
    }

    fun getPostId(): String? {
        return postId
    }

    fun getPost(): AmityPost? {
        return post
    }

    fun getChannelId(): String? {
        return channelId
    }

    fun isChannelEnabled(): Boolean? {
        return channelEnabled
    }

    fun isParent(): Boolean {
        return isParent
    }

    fun getParentStreamId(): String? {
        return parentStreamId
    }

    fun getChildStreamIds(): List<String> {
        return childStreamIds
    }

    fun getChildStreams(): List<AmityStream> {
        return childStreams
    }

    fun getChannel(): AmityChannel? {
        return channel
    }

    fun getBroadcasterData(): AmityBroadcasterData? {
        broadcasterData?.let {
            return AmityBroadcasterData(broadcasterData)
        } ?: kotlin.run {
            return null
        }
    }

    fun getStreamModeration(): AmityStreamModeration? {
        return moderation
    }

    fun isBanned(): Boolean {
        return watcherData == null || isBanned == true
    }

    enum class Status(val apiKey: String) {
        IDLE("idle"),
        LIVE("live"),
        ENDED("ended"),
        RECORDED("recorded");

        companion object {
            fun enumOf(value: String?): Status {
                return values().find { it.apiKey == value } ?: IDLE
            }
        }
    }

    enum class ReferenceType(val apiKey: String) {
        POST("post");

        companion object {
            fun enumOf(value: String?): ReferenceType {
                return values().find { it.apiKey == value } ?: POST
            }
        }
    }

    enum class TargetType(val apiKey: String) {
        Community("community"),
        User("user");

        companion object {
            fun enumOf(value: String?): TargetType {
                return values().find { it.apiKey == value } ?: Community
            }
        }
    }

    override fun updatedAt(): DateTime {
        return updatedAt
    }

    override fun uniqueId(): String {
        return streamId
    }

}