package com.amity.socialcloud.sdk.model.core.user

import com.amity.socialcloud.sdk.model.core.user.AmityUserType.BOT
import com.amity.socialcloud.sdk.model.core.user.AmityUserType.SIGNED_IN
import com.amity.socialcloud.sdk.model.core.user.AmityUserType.VISITOR
import com.ekoapp.ekosdk.internal.data.model.EkoAccount

enum class AmityUserType {
    SIGNED_IN,
    VISITOR,
    BOT;

    fun getValue(): String {
        return when (this) {
            VISITOR -> "visitor"
            BOT -> "bot"
            SIGNED_IN -> "signed_in"
            else -> "signed_in" // Default value
        }
    }

    companion object {
        fun fromString(type: String?): AmityUserType {
            return when (type?.lowercase()) {
                VISITOR.getValue() -> VISITOR
                BOT.getValue() -> BOT
                else -> SIGNED_IN // Default value when null or unrecognized
            }
        }
    }
}

fun EkoAccount.isVisitor(): Boolean {
    return this.userType == VISITOR.getValue()
}