package com.amity.socialcloud.sdk.core.data.settings.network

import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsEntity
import com.ekoapp.ekosdk.internal.ChatSettingsEntity
import com.ekoapp.ekosdk.internal.SocialSettingsEntity
import com.ekoapp.ekosdk.internal.data.UserDatabase
import io.reactivex.rxjava3.core.Completable

internal class NetworkSettingsLocalDataStore {

    fun saveChatSettings(entities: List<ChatSettingsEntity>): Completable {
        return Completable.fromAction {
            UserDatabase.get().chatSettingsDao().save(entities)
        }
    }

    fun saveSocialSettings(entities: List<SocialSettingsEntity>): Completable {
        return Completable.fromAction {
            UserDatabase.get().socialSettingsDao().save(entities)
        }
    }

    fun saveUserSettings(entities: List<UserSettingsEntity>): Completable {
        return Completable.fromAction {
            UserDatabase.get().userSettingsDao().save(entities)
        }
    }

}