package com.amity.socialcloud.sdk.social.domain.event

import com.amity.socialcloud.sdk.model.social.event.AmityEvent
import com.amity.socialcloud.sdk.social.data.event.EventRepository
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.schedulers.Schedulers

internal class EventGetUseCase {

    fun execute(eventId: String): AmityEvent? {
        val event = EventRepository().getEvent(eventId)
        Completable.fromCallable {
            event?.let {
                EventComposerUseCase().execute(it)
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return event
    }

}
