package com.amity.socialcloud.sdk.social.data.post.paging

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper
import com.ekoapp.ekosdk.internal.keycreator.QueryStreamKeyCreator

internal class GlobalFeedKeyCreator(
    private val dataTypes: List<AmityPost.DataType>,
    private val includeMixedStructure: Boolean,
) :
    QueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "isDeleted" to false,
            "dataTypes" to PostRepositoryHelper.convertPostTypesToString(dataTypes),
            "includeMixedStructure" to includeMixedStructure,
        )
    }

    override fun optionalFilterQuery(): String {
        return getConditionStatement()
    }

    private fun getConditionStatement(
    ): String {
        //post is not deleted filter
        var filterQuery = "post.isDeleted = 0"
        
        //structureType filter - exclude mixed structure posts when includeMixedStructure is false
        if (!includeMixedStructure) {
            filterQuery += " and (post.structureType != 'mixed' OR post.structureType IS NULL)"
        }

        //compose all condition
        return filterQuery
    }
}