/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.engine.analytics;

import com.amity.socialcloud.sdk.core.data.analytics.AnalyticsRepository;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncPriority;
import com.amity.socialcloud.sdk.core.engine.analytics.AnalyticsEventSyncer;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0007J\u0006\u0010\t\u001a\u00020\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0007H\u0002J\b\u0010\u0011\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncer;", "", "<init>", "()V", "syncDisposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "start", "", "stop", "deleteAllAnalyticsEvents", "syncCapturedEvent", "syncPriority", "Lcom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncPriority;", "handleSyncError", "error", "", "createHighPrioritySyncTimer", "createLowPrioritySyncTimer", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nAnalyticsEventSyncer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsEventSyncer.kt\ncom/amity/socialcloud/sdk/core/engine/analytics/AnalyticsEventSyncer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class AnalyticsEventSyncer {
    @NotNull
    private final CompositeDisposable syncDisposable = new CompositeDisposable();

    public final void start() {
        this.syncDisposable.clear();
        this.createHighPrioritySyncTimer();
        this.createLowPrioritySyncTimer();
    }

    public final void stop() {
        this.syncDisposable.clear();
    }

    public final void deleteAllAnalyticsEvents() {
        new AnalyticsRepository().deleteAllAnalyticsEvents().subscribeOn(Schedulers.io()).doOnError((Consumer)deleteAllAnalyticsEvents.1.INSTANCE).subscribe();
    }

    private final void syncCapturedEvent(AnalyticsEventSyncPriority syncPriority) {
        AnalyticsRepository repository = new AnalyticsRepository();
        repository.sendAnalyticsEvents(syncPriority).subscribeOn(Schedulers.io()).doOnComplete(AnalyticsEventSyncer::syncCapturedEvent$lambda$0).doOnError(new Consumer(this){
            final /* synthetic */ AnalyticsEventSyncer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void accept(Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AnalyticsEventSyncer.access$handleSyncError(this.this$0, it);
            }
        }).subscribe();
    }

    private final void handleSyncError(Throwable error) {
        if (error instanceof AmityException) {
            Integer n = ((AmityException)error).getHttpStatusCode$amity_sdk_release();
            int n2 = 422;
            if (n != null && n == n2) {
                this.stop();
                this.deleteAllAnalyticsEvents();
            } else {
                IntRange intRange = new IntRange(500, 599);
                Integer n3 = ((AmityException)error).getHttpStatusCode$amity_sdk_release();
                if (n3 != null && intRange.contains(n3.intValue())) {
                    this.stop();
                }
            }
        }
    }

    private final void createHighPrioritySyncTimer() {
        Disposable disposable = Flowable.interval((long)1000L, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).map(new Function(this){
            final /* synthetic */ AnalyticsEventSyncer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void apply(Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AnalyticsEventSyncer.access$syncCapturedEvent(this.this$0, AnalyticsEventSyncPriority.HIGH);
            }
        }).subscribe();
        CompositeDisposable compositeDisposable = this.syncDisposable;
        Disposable p0 = disposable;
        boolean bl = false;
        compositeDisposable.add(p0);
    }

    private final void createLowPrioritySyncTimer() {
        Disposable disposable = Flowable.interval((long)1000L, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS).subscribeOn(Schedulers.io()).map(new Function(this){
            final /* synthetic */ AnalyticsEventSyncer this$0;
            {
                this.this$0 = $receiver;
            }

            public final void apply(Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AnalyticsEventSyncer.access$syncCapturedEvent(this.this$0, AnalyticsEventSyncPriority.LOW);
            }
        }).subscribe();
        CompositeDisposable compositeDisposable = this.syncDisposable;
        Disposable p0 = disposable;
        boolean bl = false;
        compositeDisposable.add(p0);
    }

    private static final void syncCapturedEvent$lambda$0() {
    }

    public static final /* synthetic */ void access$handleSyncError(AnalyticsEventSyncer $this, Throwable error) {
        $this.handleSyncError(error);
    }

    public static final /* synthetic */ void access$syncCapturedEvent(AnalyticsEventSyncer $this, AnalyticsEventSyncPriority syncPriority) {
        $this.syncCapturedEvent(syncPriority);
    }
}

