package com.amity.socialcloud.sdk.video.data.room

import androidx.room.Dao
import androidx.room.Query
import androidx.room.Transaction
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import org.joda.time.DateTime

@Dao
abstract class RoomDao : EkoObjectDao<RoomEntity>() {

    @Query("SELECT * FROM room WHERE roomId = :roomId")
    abstract fun getByIdImpl(roomId: String): Flowable<RoomEntity>
    fun getById(roomId: String): Flowable<RoomEntity> = getByIdImpl(roomId)

    @Query("SELECT * FROM room WHERE roomId = :roomId")
    abstract fun getByIdNowImpl(roomId: String): RoomEntity?
    override fun getByIdNow(roomId: String): RoomEntity? = getByIdNowImpl(roomId)

    @Query("SELECT * FROM room WHERE roomId in (:roomIds)")
    abstract fun getByIdsNowImpl(roomIds: List<String>): List<RoomEntity>
    override fun getByIdsNow(roomIds: List<String>): List<RoomEntity> = getByIdsNowImpl(roomIds)

    @Query("SELECT * FROM room WHERE status in (:statuses) AND room.updatedAt > :now ORDER BY room.updatedAt DESC LIMIT 1")
    abstract fun getLatestRoomImpl(statuses: List<String>, now: DateTime): Flowable<RoomEntity>
    fun getLatestRoom(statuses: List<String>): Flowable<RoomEntity> = getLatestRoomImpl(statuses, DateTime.now())

    @Transaction
    open fun updateRoom(roomId: String) { updateRoomImpl(roomId) }
    @Query("UPDATE room set roomId = :roomId where roomId = :roomId")
    abstract fun updateRoomImpl(roomId: String)

    @Query("DELETE from room where roomId = :roomId")
    abstract fun deleteById(roomId: String): Completable

    @Query("DELETE FROM room")
    abstract override fun deleteAll()
}
