package com.amity.socialcloud.sdk.social.domain.community

import com.amity.socialcloud.sdk.core.domain.ComposerUseCase
import com.amity.socialcloud.sdk.core.domain.user.UserGetUseCase
import com.amity.socialcloud.sdk.model.social.community.AmityJoinRequest

internal class CommunityGetJoinRequestComposerUseCase : ComposerUseCase() {
    fun execute(joinRequest: AmityJoinRequest): AmityJoinRequest {
        addUser(joinRequest = joinRequest)
        return joinRequest
    }

    private fun addUser(joinRequest: AmityJoinRequest) {
        val user = UserGetUseCase().execute(joinRequest.getRequestorPublicId() ?: "")
        joinRequest.user = user
    }
}