package com.amity.socialcloud.sdk.social.data.post.paging

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepositoryHelper
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator


internal class SemanticSearchPostKeyCreator(
    private val query: String,
    private val targetType: String?,
    private val targetId: String?,
    private val postTypes: List<AmityPost.DataType>,
    private val matchingOnlyParentPosts: Boolean,
    private val includeMixedStructure: Boolean,
    ) : DynamicQueryStreamKeyCreator {

    override fun toMap(): Map<String, Any> {
        return mapOf(
            "query" to query,
            "targetId" to (targetId ?: "null"),
            "targetType" to (targetType ?: "null"),
            "matchingOnlyParentPost" to matchingOnlyParentPosts,
            "postTypes" to PostRepositoryHelper.convertPostTypesToString(postTypes),
            "includeMixedStructure" to includeMixedStructure,
        )
    }

    override fun getFilterQuery(): String {
        return getConditionStatement(
            targetType = targetType,
            targetId = targetId,
            matchingOnlyParentPost = matchingOnlyParentPosts,
            postTypes = postTypes,
            includeMixedStructure = includeMixedStructure
        )
    }

    private fun getConditionStatement(
        targetType: String?,
        targetId: String?,
        matchingOnlyParentPost: Boolean,
        postTypes: List<AmityPost.DataType>,
        includeMixedStructure: Boolean
    ): String {
        val isDeletedFilterStatement = "post.isDeleted = 0"
        
        //structureType filter - exclude mixed structure posts when includeMixedStructure is false
        var structureTypeFilterStatement = ""
        if (!includeMixedStructure) {
            structureTypeFilterStatement = " and (post.structureType != 'mixed' OR post.structureType IS NULL)"
        }

        return isDeletedFilterStatement + structureTypeFilterStatement
    }

}