package com.amity.socialcloud.sdk.model.social.event

enum class AmityEventStatus(val apiKey: String) {
    DRAFT("draft"),
    SCHEDULED("scheduled"),
    LIVE("live"),
    ENDED("ended"),
    CANCELLED("cancelled"),
    UNKNOWN("unknown");

    companion object {
        fun enumOf(value: String?): AmityEventStatus {
            return values().find { it.apiKey == value } ?: UNKNOWN
        }
    }
}
