package com.amity.socialcloud.sdk.core.data.session

import com.amity.socialcloud.sdk.core.CoreClient
import com.amity.socialcloud.sdk.core.LogoutProcessState
import com.amity.socialcloud.sdk.model.core.user.AmityUserType
import com.amity.socialcloud.sdk.model.core.user.isVisitor
import com.ekoapp.ekosdk.internal.data.EkoDatabase
import com.ekoapp.ekosdk.internal.data.model.EkoAccount
import com.ekoapp.ekosdk.internal.data.model.EkoApiKey
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single
import io.reactivex.rxjava3.schedulers.Schedulers

internal class SessionLocalDataStore {

    fun getApiKey(): Single<EkoApiKey> {
        return EkoDatabase.get().apiKeyDao().currentApiKeySingle
    }

    fun activateAccount(userId: String): EkoAccount {
        return EkoDatabase.get().accountDao().activateAccount(userId)
    }

    fun activateVisitorAccount(): EkoAccount {
        return EkoDatabase.get().accountDao().activateVisitor()
    }

    fun updateAccount(account: EkoAccount): Completable {
        return Completable.fromAction {
            EkoDatabase.get().accountDao().update(account)
        }.subscribeOn(Schedulers.io())
    }

    fun logoutAccount(userId: String) {
        EkoDatabase.get().accountDao().logoutAccount(userId)
        CoreClient.logoutProcessState = LogoutProcessState.IDLE
    }

    fun getActiveUserId(): String {
        var activeUserId = ""
        Completable.fromCallable {
            val account = EkoDatabase.get().accountDao().currentAccountNow
            account?.userId?.let {
                if (!account.isVisitor()) {
                    activeUserId = it
                }
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return activeUserId
    }

    fun getActiveUserType(): AmityUserType {
        var userType = AmityUserType.SIGNED_IN
        Completable.fromCallable {
            val account = EkoDatabase.get().accountDao().currentAccountNow
            account?.userType?.let {
                userType = AmityUserType.fromString(it)
            }
        }.subscribeOn(Schedulers.io())
                .blockingAwait()
        return userType
    }

    fun getVisitorDeviceId(): String {
        var deviceId = ""
        Completable.fromCallable {
            activateVisitorAccount().let { account ->
                deviceId = account.deviceId
            }
        }.subscribeOn(Schedulers.io())
            .blockingAwait()
        return deviceId
    }

    fun getCurrentAccount(): EkoAccount? {
        return EkoDatabase.get().accountDao().currentAccountNow
    }
}