/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.core.user;

import androidx.paging.PagingData;
import com.amity.socialcloud.sdk.api.core.follow.AmityRelationShip;
import com.amity.socialcloud.sdk.api.core.user.query.AmityUserQuery;
import com.amity.socialcloud.sdk.api.core.user.search.AmityUserSearch;
import com.amity.socialcloud.sdk.core.domain.user.UserGetByIdsUseCase;
import com.amity.socialcloud.sdk.model.core.analytics.AmityViewedType;
import com.amity.socialcloud.sdk.model.core.user.AmityUser;
import com.ekoapp.ekosdk.internal.usecase.user.FlagUserUseCase;
import com.ekoapp.ekosdk.internal.usecase.user.GetBlockedUsersPagingDataUseCase;
import com.ekoapp.ekosdk.internal.usecase.user.GetViewedUsersPagingDataUseCase;
import com.ekoapp.ekosdk.internal.usecase.user.UnFlagUserUseCase;
import com.ekoapp.ekosdk.internal.usecase.user.UserLiveObjectUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\tJ \u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000f0\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\tJ\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00160\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00160\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\t\u00a8\u0006\u001d"}, d2={"Lcom/amity/socialcloud/sdk/api/core/user/AmityUserRepository;", "", "<init>", "()V", "getUsers", "Lcom/amity/socialcloud/sdk/api/core/user/query/AmityUserQuery$Builder;", "searchUsers", "Lcom/amity/socialcloud/sdk/api/core/user/search/AmityUserSearch$Builder;", "keyword", "", "getUser", "Lio/reactivex/rxjava3/core/Flowable;", "Lcom/amity/socialcloud/sdk/model/core/user/AmityUser;", "userId", "getUserByIds", "", "userIds", "", "flagUser", "Lio/reactivex/rxjava3/core/Completable;", "unflagUser", "getBlockedUsers", "Landroidx/paging/PagingData;", "relationship", "Lcom/amity/socialcloud/sdk/api/core/follow/AmityRelationShip;", "getReachedUsers", "viewedType", "Lcom/amity/socialcloud/sdk/model/core/analytics/AmityViewedType;", "viewedId", "amity-sdk_release"})
public final class AmityUserRepository {
    @NotNull
    public final AmityUserQuery.Builder getUsers() {
        return new AmityUserQuery.Builder();
    }

    @NotNull
    public final AmityUserSearch.Builder searchUsers(@NotNull String keyword) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        return new AmityUserSearch.Builder().keyword$amity_sdk_release(keyword);
    }

    @NotNull
    public final Flowable<AmityUser> getUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new UserLiveObjectUseCase().execute(userId);
    }

    @NotNull
    public final Flowable<List<AmityUser>> getUserByIds(@NotNull Set<String> userIds) {
        Intrinsics.checkNotNullParameter(userIds, (String)"userIds");
        return new UserGetByIdsUseCase().execute(userIds);
    }

    @NotNull
    public final Completable flagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new FlagUserUseCase().execute(userId);
    }

    @NotNull
    public final Completable unflagUser(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return new UnFlagUserUseCase().execute(userId);
    }

    @NotNull
    public final Flowable<PagingData<AmityUser>> getBlockedUsers() {
        return new GetBlockedUsersPagingDataUseCase().execute();
    }

    @NotNull
    public final AmityRelationShip relationship() {
        return new AmityRelationShip();
    }

    @NotNull
    public final Flowable<PagingData<AmityUser>> getReachedUsers(@NotNull AmityViewedType viewedType, @NotNull String viewedId) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewedType), (String)"viewedType");
        Intrinsics.checkNotNullParameter((Object)viewedId, (String)"viewedId");
        return new GetViewedUsersPagingDataUseCase().execute(viewedType, viewedId);
    }
}

