package com.amity.socialcloud.sdk.video.domain.room

import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.video.data.room.RoomModelMapper
import com.amity.socialcloud.sdk.video.domain.room.compose.RoomComposerUseCase

internal class GetRoomNowUseCase {
    fun execute(roomId: String): AmityRoom? {
        return RoomRepository().queryFromCache(roomId)
            ?.let(RoomModelMapper()::map)
            ?.let(RoomComposerUseCase()::execute)
    }
}
