package com.amity.socialcloud.sdk.model.core.reaction

import android.os.Parcelable
import kotlinx.parcelize.Parcelize

@Parcelize
class AmityReactionMap : HashMap<String, Int>(), Parcelable {
    val reactionNames: Set<String>
        get() = keys

    fun getCount(reactionName: String?): Int {
        return if (!containsKey(reactionName)) {
            0
        } else get(reactionName)!!
    }
}
