package com.amity.socialcloud.sdk.helper.core.hashtag

class AmityHashtagBuilder {
    private val hashtags = mutableListOf<AmityHashtag>()

    fun addHashtag(hashtag: AmityHashtag): AmityHashtagBuilder {
        hashtags.add(hashtag)
        return this
    }

    fun addHashtags(hashtags: List<AmityHashtag>): AmityHashtagBuilder {
        this.hashtags.addAll(hashtags)
        return this
    }

    fun build(): List<AmityHashtag> {
        return hashtags.toList()
    }
}
